/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.lucene.AbstractIndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4600)
public final class ChunkCacheKey
extends AbstractIndexScopedKey {
    private final int chunkId;
    private final String fileName;
    private final int bufferSize;

    @ProtoFactory
    public ChunkCacheKey(String indexName, String fileName, int chunkId, int bufferSize, int affinitySegmentId) {
        super(indexName, affinitySegmentId);
        if (fileName == null) {
            throw new IllegalArgumentException("File name must not be null");
        }
        this.fileName = fileName;
        this.chunkId = chunkId;
        this.bufferSize = bufferSize;
    }

    @ProtoField(number=3, defaultValue="0")
    public int getChunkId() {
        return this.chunkId;
    }

    @ProtoField(number=4)
    public String getFileName() {
        return this.fileName;
    }

    @ProtoField(number=5, defaultValue="1024")
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public <T> T accept(KeyVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.chunkId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ChunkCacheKey.class != obj.getClass()) {
            return false;
        }
        ChunkCacheKey other = (ChunkCacheKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "C|" + this.fileName + "|" + this.chunkId + "|" + this.bufferSize + "|" + this.indexName + "|" + this.affinitySegmentId;
    }
}

