/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.lucene.AbstractIndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4601)
public final class FileCacheKey
extends AbstractIndexScopedKey {
    private final String fileName;

    @ProtoFactory
    public FileCacheKey(String indexName, String fileName, int affinitySegmentId) {
        super(indexName, affinitySegmentId);
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.fileName = fileName;
    }

    @Override
    public <T> T accept(KeyVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    @ProtoField(number=3)
    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || FileCacheKey.class != obj.getClass()) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        return this.fileName.equals(other.fileName) && this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "M|" + this.fileName + "|" + this.indexName + "|" + this.affinitySegmentId;
    }
}

