/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.testutils.RepeatableLongByteSequence;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.InfinispanDirectoryIOTest")
public class InfinispanDirectoryIOTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWholeFile() throws IOException {
        int BUFFER_SIZE = 64;
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index", 64);
        try {
            int SHORT_FILE_SIZE = 61;
            this.createFileWithRepeatableContent(dir, "SingleChunk.txt", 61);
            this.assertReadByteWorkingCorrectly(dir, "SingleChunk.txt", 61);
            this.assertReadBytesWorkingCorrectly(dir, "SingleChunk.txt", 61, 15);
            int VERY_BIG_FILE_SIZE = 10000;
            this.createFileWithRepeatableContent(dir, "MultipleChunks.txt", 10000);
            this.assertReadByteWorkingCorrectly(dir, "MultipleChunks.txt", 10000);
            this.assertReadBytesWorkingCorrectly(dir, "MultipleChunks.txt", 10000, 33);
            int LAST_CHUNK_COMPLETELY_FILLED_FILE_SIZE = 256;
            this.createFileWithRepeatableContent(dir, "LastChunkFilled.txt", 256);
            this.assertReadByteWorkingCorrectly(dir, "LastChunkFilled.txt", 256);
            this.assertReadBytesWorkingCorrectly(dir, "LastChunkFilled.txt", 256, 11);
            assert (4 == this.getChunksNumber((Cache<CacheKey, Object>)cache, "index", "LastChunkFilled.txt"));
            int LAST_CHUNK_WITH_LONELY_BYTE_FILE_SIZE = 257;
            this.createFileWithRepeatableContent(dir, "LonelyByteInLastChunk.txt", 257);
            this.assertReadByteWorkingCorrectly(dir, "LonelyByteInLastChunk.txt", 257);
            this.assertReadBytesWorkingCorrectly(dir, "LonelyByteInLastChunk.txt", 257, 12);
            assert (5 == this.getChunksNumber((Cache<CacheKey, Object>)cache, "index", "LonelyByteInLastChunk.txt"));
        }
        finally {
            for (String fileName : dir.listAll()) {
                dir.deleteFile(fileName);
            }
            cache.getCacheManager().stop();
            dir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadRandomSampleFile() throws IOException {
        int BUFFER_SIZE = 64;
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index", 64);
        try {
            int FILE_SIZE = 1000;
            this.createFileWithRepeatableContent(dir, "RandomSampleFile.txt", 1000);
            IndexInput indexInput = dir.openInput("RandomSampleFile.txt");
            assert (indexInput.length() == 1000L);
            RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
            Random r = new Random();
            long seekPoint = 0L;
            for (int i = 0; i < 1000; ++i) {
                if (seekPoint == (long)i) {
                    assert (bytesGenerator.nextByte() == indexInput.readByte());
                    seekPoint = indexInput.getFilePointer() + (long)r.nextInt(10);
                    indexInput.seek(seekPoint);
                    continue;
                }
                bytesGenerator.nextByte();
            }
            indexInput.close();
        }
        finally {
            for (String fileName : dir.listAll()) {
                dir.deleteFile(fileName);
            }
            cache.getCacheManager().stop();
            dir.close();
        }
    }

    private void assertReadBytesWorkingCorrectly(InfinispanDirectory dir, String fileName, int contentFileSizeExpected, int arrayLengthToRead) throws IOException {
        int nextBytesToRead;
        IndexInput indexInput = dir.openInput(fileName);
        assert (indexInput.length() == (long)contentFileSizeExpected);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        byte[] readBytes = new byte[arrayLengthToRead];
        byte[] expectedBytes = new byte[arrayLengthToRead];
        for (long toRead = (long)contentFileSizeExpected; toRead > 0L; toRead -= (long)nextBytesToRead) {
            if (toRead < (long)arrayLengthToRead) {
                readBytes = new byte[(int)toRead];
                expectedBytes = new byte[(int)toRead];
            }
            nextBytesToRead = (int)Math.min(toRead, (long)arrayLengthToRead);
            bytesGenerator.nextBytes(expectedBytes);
            indexInput.readBytes(readBytes, 0, nextBytesToRead);
            assert (Arrays.equals(expectedBytes, readBytes));
        }
        indexInput.close();
    }

    private void assertReadByteWorkingCorrectly(InfinispanDirectory dir, String fileName, int contentFileSizeExpected) throws IOException {
        IndexInput indexInput = dir.openInput(fileName);
        assert (indexInput.length() == (long)contentFileSizeExpected);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        for (int i = 0; i < contentFileSizeExpected; ++i) {
            assert (bytesGenerator.nextByte() == indexInput.readByte());
        }
        indexInput.close();
    }

    private int getChunksNumber(Cache<CacheKey, Object> cache, String index, String fileName) {
        int chunksNumber = 0;
        while (cache.containsKey((Object)new ChunkCacheKey(index, fileName, chunksNumber))) {
            ++chunksNumber;
        }
        return chunksNumber;
    }

    private void createFileWithRepeatableContent(InfinispanDirectory dir, String fileName, int contentFileSize) throws IOException {
        IndexOutput indexOutput = dir.createOutput(fileName);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        for (int i = 0; i < contentFileSize; ++i) {
            indexOutput.writeByte(bytesGenerator.nextByte());
        }
        indexOutput.close();
    }

    @Test(enabled=false)
    public void testReadChunks() throws Exception {
        int bytesRead;
        long toRead;
        int bytesRead2;
        int BUFFER_SIZE = 64;
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index", 64);
        FileMetadata file1 = new FileMetadata();
        FileCacheKey key1 = new FileCacheKey("index", "Hello.txt");
        cache.put((Object)key1, (Object)file1);
        FileMetadata file2 = new FileMetadata();
        FileCacheKey key2 = new FileCacheKey("index", "World.txt");
        cache.put((Object)key2, (Object)file2);
        String helloText = "Hello world.  This is some text.";
        cache.put((Object)new ChunkCacheKey("index", "Hello.txt", 0), (Object)helloText.getBytes());
        String worldText = "This String should contain more than sixty four characters but less than one hundred and twenty eight.";
        byte[] buf = new byte[64];
        System.arraycopy(worldText.getBytes(), 0, buf, 0, 64);
        cache.put((Object)new ChunkCacheKey("index", "World.txt", 0), (Object)buf);
        String part1 = new String(buf);
        buf = new byte[64];
        System.arraycopy(worldText.getBytes(), 64, buf, 0, worldText.length() - 64);
        cache.put((Object)new ChunkCacheKey("index", "World.txt", 1), (Object)buf);
        String part2 = new String(buf);
        assert (worldText.equals(part1 + part2.trim()));
        file1.setSize((long)helloText.length());
        file2.setSize((long)worldText.length());
        HashSet<String> s = new HashSet<String>();
        s.add("Hello.txt");
        s.add("World.txt");
        HashSet<String> other = new HashSet<String>(Arrays.asList(dir.list()));
        assert (((Object)s).equals(other));
        IndexInput ii = dir.openInput("Hello.txt");
        assert (ii.length() == (long)helloText.length());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < ii.length()) {
            baos.write(ii.readByte());
            ++i;
        }
        assert (new String(baos.toByteArray()).equals(helloText));
        ii = dir.openInput("World.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        i = 0;
        while ((long)i < ii.length()) {
            baos.write(ii.readByte());
            ++i;
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        ii = dir.openInput("Hello.txt");
        assert (ii.length() == (long)helloText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead2) {
            buf = new byte[19];
            bytesRead2 = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead2);
            baos.write(buf, 0, bytesRead2);
        }
        assert (new String(baos.toByteArray()).equals(helloText));
        ii = dir.openInput("World.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead2) {
            buf = new byte[19];
            bytesRead2 = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead2);
            baos.write(buf, 0, bytesRead2);
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        dir.deleteFile("Hello.txt");
        assert (null == cache.get((Object)new FileCacheKey("index", "Hello.txt")));
        assert (null == cache.get((Object)new ChunkCacheKey("index", "Hello.txt", 0)));
        Object ob1 = cache.get((Object)new FileCacheKey("index", "World.txt"));
        Object ob2 = cache.get((Object)new ChunkCacheKey("index", "World.txt", 0));
        Object ob3 = cache.get((Object)new ChunkCacheKey("index", "World.txt", 1));
        dir.renameFile("World.txt", "HelloWorld.txt");
        assert (null == cache.get((Object)new FileCacheKey("index", "Hello.txt")));
        assert (null == cache.get((Object)new ChunkCacheKey("index", "Hello.txt", 0)));
        assert (null == cache.get((Object)new ChunkCacheKey("index", "Hello.txt", 1)));
        assert (cache.get((Object)new FileCacheKey("index", "HelloWorld.txt")).equals(ob1));
        assert (cache.get((Object)new ChunkCacheKey("index", "HelloWorld.txt", 0)).equals(ob2));
        assert (cache.get((Object)new ChunkCacheKey("index", "HelloWorld.txt", 1)).equals(ob3));
        ii = dir.openInput("HelloWorld.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead) {
            buf = new byte[19];
            bytesRead = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead);
            baos.write(buf, 0, bytesRead);
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        cache.getCacheManager().stop();
        dir.close();
    }

    public void testWriteChunks() throws Exception {
        int BUFFER_SIZE = 64;
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index", 64);
        IndexOutput io = dir.createOutput("MyNewFile.txt");
        io.writeByte((byte)66);
        io.writeByte((byte)69);
        io.close();
        assert (dir.fileExists("MyNewFile.txt"));
        assert (null != cache.get((Object)new ChunkCacheKey("index", "MyNewFile.txt", 0)));
        byte[] buf = new byte[9];
        IndexInput ii = dir.openInput("MyNewFile.txt");
        ii.readBytes(buf, 0, (int)ii.length());
        assert (new String(new byte[]{66, 69}).equals(new String(buf).trim()));
        String testText = "This is some rubbish again that will span more than one chunk - one hopes.  Who knows, maybe even three or four chunks.";
        io.seek(0L);
        io.writeBytes(testText.getBytes(), 0, testText.length());
        io.close();
        byte[] chunk1 = (byte[])cache.get((Object)new ChunkCacheKey("index", "MyNewFile.txt", 0));
        byte[] chunk2 = (byte[])cache.get((Object)new ChunkCacheKey("index", "MyNewFile.txt", 1));
        assert (null != chunk1);
        assert (null != chunk2);
        assert (testText.equals(new String(chunk1) + new String(chunk2).trim()));
        cache.getCacheManager().stop();
        dir.close();
    }

    public void testWriteChunksDefaultChunks() throws Exception {
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index");
        String testText = "This is some rubbish";
        byte[] testTextAsBytes = testText.getBytes();
        IndexOutput io = dir.createOutput("MyNewFile.txt");
        io.writeByte((byte)1);
        io.writeByte((byte)2);
        io.writeByte((byte)3);
        io.writeBytes(testTextAsBytes, testTextAsBytes.length);
        io.close();
        assert (null != cache.get((Object)new FileCacheKey("index", "MyNewFile.txt")));
        assert (null != cache.get((Object)new ChunkCacheKey("index", "MyNewFile.txt", 0)));
        IndexInput ii = dir.openInput("MyNewFile.txt");
        assert (ii.readByte() == 1);
        assert (ii.readByte() == 2);
        assert (ii.readByte() == 3);
        byte[] buf = new byte[32];
        ii.readBytes(buf, 0, testTextAsBytes.length);
        assert (testText.equals(new String(buf).trim()));
        cache.getCacheManager().stop();
        dir.close();
    }
}

