/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.profiling.LuceneUserThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.ClusteredCacheFactory;
import org.infinispan.manager.CacheManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.PerformanceCompareStressTest")
public class PerformanceCompareStressTest {
    private static final int THREADS = 1;
    private static final long DURATION_MS = 100000L;
    private static final ClusteredCacheFactory cacheFactory = new ClusteredCacheFactory(CacheTestSupport.createTestConfiguration());

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        this.testDirectory((Directory)dir, "RAMDirectory");
    }

    @Test
    public void profileTestInfinispanDirectory() throws InterruptedException, IOException {
        Cache<CacheKey, Object> cache = cacheFactory.createClusteredCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "iname");
        this.testDirectory((Directory)dir, "InfinispanClustered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheManager cacheManager = CacheTestSupport.createLocalCacheManager();
        try {
            Cache cache = cacheManager.getCache();
            InfinispanDirectory dir = new InfinispanDirectory(cache, "iname");
            this.testDirectory((Directory)dir, "InfinispanLocal");
        }
        finally {
            cacheManager.stop();
        }
    }

    private void testDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        SharedState state = new SharedState(1000);
        CacheTestSupport.initializeDirectory(dir);
        ExecutorService e = Executors.newFixedThreadPool(1);
        for (int i = 0; i < 1; ++i) {
            e.execute(new LuceneUserThread(dir, state));
        }
        e.shutdown();
        state.startWaitingThreads();
        Thread.sleep(100000L);
        state.quit();
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        e.awaitTermination(10L, TimeUnit.SECONDS);
        System.out.println("Test " + testLabel + " run in " + 100000L + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
    }

    @BeforeClass
    public static void beforeTest() {
        cacheFactory.start();
    }

    @AfterClass
    public static void afterTest() {
        cacheFactory.stop();
    }
}

