/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.util.HashSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SharedState {
    final BlockingDeque<String> stringsInIndex = new LinkedBlockingDeque<String>();
    final BlockingDeque<String> stringsOutOfIndex = new LinkedBlockingDeque<String>();
    private final AtomicLong indexWriterActionCount = new AtomicLong();
    private final AtomicLong searchingActionCount = new AtomicLong();
    private final AtomicInteger errors = new AtomicInteger(0);
    private volatile boolean quit = false;
    private final CountDownLatch startSignal = new CountDownLatch(1);

    public SharedState(int initialDictionarySize) {
        HashSet<String> strings = new HashSet<String>();
        for (int i = 1; i <= initialDictionarySize; ++i) {
            strings.add(String.valueOf(i));
        }
        this.stringsOutOfIndex.addAll(strings);
    }

    public boolean needToQuit() {
        return this.quit || this.errors.get() != 0;
    }

    public void errorManage(Exception e) {
        this.errors.incrementAndGet();
        e.printStackTrace();
    }

    public long incrementIndexWriterTaskCount(long delta) {
        long count = this.indexWriterActionCount.addAndGet(delta);
        return count;
    }

    public long incrementIndexSearchesCount(long delta) {
        long count = this.searchingActionCount.addAndGet(delta);
        return count;
    }

    public String getStringToAddToIndex() throws InterruptedException {
        return this.stringsOutOfIndex.take();
    }

    public void quit() {
        this.quit = true;
    }

    public void addStringWrittenToIndex(String termToAdd) {
        this.stringsInIndex.add(termToAdd);
    }

    public void waitForStart() throws InterruptedException {
        this.startSignal.await();
    }

    public void startWaitingThreads() {
        this.startSignal.countDown();
    }
}

