/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.infinispan.config.Configuration;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.locking.LuceneLockFactory;
import org.infinispan.lucene.locking.SharedLuceneLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.LockManagerFunctionalTest", enabled=true)
public class LockManagerFunctionalTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = CacheTestSupport.createTestConfiguration();
        this.createClusteredCaches(2, "lucene", replSync);
    }

    public void testLuceneIndexLocking() throws IOException {
        String commonIndexName = "myIndex";
        LuceneLockFactory lockManagerA = new LuceneLockFactory(this.cache(0, "lucene"), "myIndex");
        LuceneLockFactory lockManagerB = new LuceneLockFactory(this.cache(1, "lucene"), "myIndex");
        LuceneLockFactory isolatedLockManager = new LuceneLockFactory(this.cache(0, "lucene"), "anotherIndex");
        SharedLuceneLock luceneLockA = lockManagerA.makeLock("write.lock");
        SharedLuceneLock luceneLockB = lockManagerB.makeLock("write.lock");
        SharedLuceneLock anotherLock = isolatedLockManager.makeLock("write.lock");
        assert (luceneLockA.obtain());
        assert (luceneLockB.isLocked());
        assert (!anotherLock.isLocked());
        assert (!luceneLockA.obtain());
        assert (!luceneLockB.obtain());
        luceneLockA.release();
        assert (!luceneLockB.isLocked());
        assert (luceneLockB.obtain());
        lockManagerA.clearLock("write.lock");
        assert (!luceneLockB.isLocked());
    }
}

