/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.CacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.InfinispanDirectoryStressTest")
public class InfinispanDirectoryStressTest {
    private static final Log log = LogFactory.getLog(InfinispanDirectoryStressTest.class);
    public static final int THREADS_NUM = 50;
    public static final int TURNS_NUM = 300;
    private AtomicInteger writeCount = new AtomicInteger(0);

    public void testInfinispanDirectory() throws Exception {
        int OPERATIONS = 100;
        CacheManager cacheManager = CacheTestSupport.createTestCacheManager();
        Cache cache = cacheManager.getCache();
        InfinispanDirectory directory = new InfinispanDirectory(cache, "indexName");
        CacheTestSupport.initializeDirectory((Directory)directory);
        File document = CacheTestSupport.createDummyDocToIndex("document.lucene", 10000);
        for (int i = 0; i < 100; ++i) {
            CacheTestSupport.doWriteOperation((Directory)directory, document);
            CacheTestSupport.doReadOperation((Directory)directory);
        }
        IndexSearcher search = new IndexSearcher((Directory)directory, true);
        Term t = new Term("info", "good");
        TermQuery query = new TermQuery(t);
        TopDocs hits = search.search((Query)query, 1);
        assert (100 == hits.totalHits);
        directory.close();
        cacheManager.stop();
    }

    public void testDirectoryWithMultipleThreads() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<InfinispanDirectoryThread> threads = new ArrayList<InfinispanDirectoryThread>();
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory directory1 = new InfinispanDirectory(cache, "indexName");
        CacheTestSupport.initializeDirectory((Directory)directory1);
        Cache cache2 = CacheTestSupport.createTestCacheManager().getCache();
        InfinispanDirectory directory2 = new InfinispanDirectory(cache2, "indexName");
        Thread.sleep(3000L);
        InfinispanDirectoryThread tr = new InfinispanDirectoryThread(latch, (Directory)directory1, true);
        threads.add(tr);
        tr.start();
        for (int i = 0; i < 49; ++i) {
            InfinispanDirectoryThread thread = i % 2 == 0 ? new InfinispanDirectoryThread(latch, (Directory)directory1, false) : new InfinispanDirectoryThread(latch, (Directory)directory2, false);
            threads.add(thread);
            thread.start();
        }
        latch.countDown();
        for (InfinispanDirectoryThread thread : threads) {
            thread.join();
        }
        for (InfinispanDirectoryThread thread : threads) {
            if (thread.e == null) continue;
            throw thread.e;
        }
        IndexSearcher search = new IndexSearcher((Directory)directory1, true);
        Term t = new Term("info", "good");
        TermQuery query = new TermQuery(t);
        int expectedDocs = this.writeCount.get();
        TopDocs hits = search.search((Query)query, 1);
        assert (expectedDocs == hits.totalHits);
        search.close();
        directory1.close();
        directory2.close();
        cache.getCacheManager().stop();
        cache2.getCacheManager().stop();
    }

    class InfinispanDirectoryThread
    extends Thread {
        Exception e;
        CountDownLatch latch;
        File document;
        Directory dir;
        boolean isWritingThread = false;

        protected InfinispanDirectoryThread(CountDownLatch latch, Directory dir, boolean isWritingThread) throws Exception {
            this.latch = latch;
            this.dir = dir;
            this.isWritingThread = isWritingThread;
            this.document = CacheTestSupport.createDummyDocToIndex("document.lucene", 10000);
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                for (int i = 0; i < 300; ++i) {
                    if (!this.isWritingThread) {
                        CacheTestSupport.doReadOperation(this.dir);
                        continue;
                    }
                    InfinispanDirectoryStressTest.this.writeCount.incrementAndGet();
                    CacheTestSupport.doWriteOperation(this.dir, this.document);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error", (Throwable)ex);
                this.e = ex;
            }
        }
    }
}

