/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.config.Configuration;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.SimpleLuceneTest")
public class SimpleLuceneTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = CacheTestSupport.createTestConfiguration();
        this.createClusteredCaches(2, "lucene", configuration);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException {
        InfinispanDirectory dirA = new InfinispanDirectory(this.cache(0, "lucene"), "indexName");
        InfinispanDirectory dirB = new InfinispanDirectory(this.cache(1, "lucene"), "indexName");
        this.writeTextToIndex((Directory)dirA, 0, "hi from node A");
        this.assertTextIsFoundInIds((Directory)dirA, "hi", 0);
        this.assertTextIsFoundInIds((Directory)dirB, "hi", 0);
        this.writeTextToIndex((Directory)dirB, 1, "hello node A, how are you?");
        this.assertTextIsFoundInIds((Directory)dirA, "hello", 1);
        this.assertTextIsFoundInIds((Directory)dirB, "hello", 1);
        this.assertTextIsFoundInIds((Directory)dirA, "node", 1, 0);
        this.assertTextIsFoundInIds((Directory)dirB, "node", 1, 0);
        this.removeByTerm((Directory)dirA, "from");
        this.assertTextIsFoundInIds((Directory)dirB, "node", 1);
        dirA.close();
        dirB.close();
    }

    @Test(description="Verifies the caches can be reused after a Directory close")
    public void testCacheReuse() throws IOException {
        this.testIndexWritingAndFinding();
        this.cache(0, "lucene").clear();
        this.testIndexWritingAndFinding();
    }

    private void removeByTerm(Directory dir, String term) throws IOException {
        IndexWriter iw = new IndexWriter(dir, LuceneSettings.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
        iw.deleteDocuments(new Term("body", term));
        iw.commit();
        iw.close();
    }

    private void assertTextIsFoundInIds(Directory dir, String term, Integer ... validDocumentIds) throws IOException {
        int expectedResults = validDocumentIds.length;
        HashSet<Integer> expectedDocumendIds = new HashSet<Integer>(Arrays.asList(validDocumentIds));
        IndexSearcher searcher = new IndexSearcher(dir, true);
        TermQuery query = new TermQuery(new Term("body", term));
        TopDocs docs = searcher.search((Query)query, null, expectedResults + 1);
        assert (docs.totalHits == expectedResults);
        for (ScoreDoc scoreDoc : docs.scoreDocs) {
            int docId = scoreDoc.doc;
            Document document = searcher.doc(docId);
            String idString = document.get("id");
            assert (idString != null);
            Integer idFoundElement = Integer.valueOf(idString);
            assert (expectedDocumendIds.contains(idFoundElement));
        }
        searcher.close();
    }

    private void writeTextToIndex(Directory dir, int id, String text) throws IOException {
        IndexWriter iw = new IndexWriter(dir, LuceneSettings.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
        Document doc = new Document();
        doc.add((Fieldable)new Field("id", String.valueOf(id), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field("body", text, Field.Store.NO, Field.Index.ANALYZED));
        iw.addDocument(doc);
        iw.commit();
        iw.close();
    }
}

