/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.LuceneSettings;

public class LuceneUserThread
implements Runnable {
    private final Directory directory;
    private final SharedState state;

    LuceneUserThread(Directory dir, SharedState state) {
        this.directory = dir;
        this.state = state;
    }

    @Override
    public void run() {
        try {
            this.state.waitForStart();
        }
        catch (InterruptedException e1) {
            this.state.errorManage(e1);
            return;
        }
        while (!this.state.needToQuit()) {
            try {
                this.testLoop();
            }
            catch (Exception e) {
                this.state.errorManage(e);
            }
        }
    }

    private void testLoop() throws IOException {
        this.addSomeStrings();
        this.verifyStringsExistInIndex();
    }

    private void addSomeStrings() throws IOException {
        HashSet strings = new HashSet();
        this.state.stringsOutOfIndex.drainTo(strings, 5);
        IndexWriter iwriter = LuceneSettings.openWriter(this.directory);
        for (String term : strings) {
            Document doc = new Document();
            doc.add((Fieldable)new Field("main", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
            iwriter.addDocument(doc);
        }
        iwriter.commit();
        iwriter.close();
        this.state.stringsInIndex.addAll(strings);
        this.state.incrementIndexWriterTaskCount(5L);
    }

    private void verifyStringsExistInIndex() throws IOException {
        HashSet strings = new HashSet();
        this.state.stringsInIndex.drainTo(strings, 50);
        IndexSearcher searcher = new IndexSearcher(this.directory, true);
        for (String term : strings) {
            TermQuery query = new TermQuery(new Term("main", term));
            TopDocs docs = searcher.search((Query)query, null, 1);
            if (docs.totalHits == 1) continue;
            throw new RuntimeException("String '" + term + "' should exist but was not found in index");
        }
        this.state.stringsInIndex.addAll(strings);
        this.state.incrementIndexSearchesCount(50L);
    }
}

