/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Random;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class CacheTestSupport {
    private static final Log log = LogFactory.getLog(CacheTestSupport.class);

    protected static CacheContainer createTestCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager((Configuration)CacheTestSupport.createTestConfiguration());
    }

    public static Configuration createTestConfiguration() {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        c.setSyncReplTimeout(10000L);
        c.setLockAcquisitionTimeout(10000L);
        c.setSyncCommitPhase(true);
        c.setL1CacheEnabled(true);
        c.setExposeJmxStatistics(false);
        c.setSyncRollbackPhase(true);
        c.setEnableDeadlockDetection(false);
        c.setInvocationBatchingEnabled(true);
        return c;
    }

    protected static File createDummyDocToIndex(String fileName, int sz) throws Exception {
        File dummyDocToIndex = new File(fileName);
        if (dummyDocToIndex.exists()) {
            boolean deleted = dummyDocToIndex.delete();
            assert (deleted);
        }
        boolean newFileCreated = dummyDocToIndex.createNewFile();
        assert (newFileCreated);
        Random r = new Random();
        FileWriter fw = new FileWriter(dummyDocToIndex);
        for (int i = 0; i < sz; ++i) {
            fw.write(Integer.toHexString(r.nextInt(16)));
        }
        fw.close();
        dummyDocToIndex.deleteOnExit();
        return dummyDocToIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doWriteOperation(Directory d, File document) throws Exception {
        IndexWriter writer = null;
        try {
            writer = LuceneSettings.openWriter(d, 2000);
            log.info((Object)"IndexWriter was constructed");
            Document doc = new Document();
            doc.add((Fieldable)new Field("path", document.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)document.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("contents", (Reader)new FileReader(document)));
            doc.add((Fieldable)new Field("info", "good", Field.Store.YES, Field.Index.ANALYZED));
            writer.addDocument(doc);
        }
        catch (LockObtainFailedException lockObtainFailedException) {
        }
        finally {
            if (writer != null) {
                writer.close();
                log.info((Object)"IndexWriter was closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doReadOperation(Directory d) throws Exception {
        IndexSearcher search = null;
        try {
            search = new IndexSearcher(d, true);
            Term term = new Term("path", "good");
            TermQuery termQuery = new TermQuery(term);
            search.search((Query)termQuery, null, 1);
        }
        finally {
            if (search != null) {
                search.close();
            }
        }
    }

    public static CacheContainer createLocalCacheManager() {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        Configuration cfg = new Configuration();
        cfg.setCacheMode(Configuration.CacheMode.LOCAL);
        cfg.setEnableDeadlockDetection(false);
        cfg.setExposeJmxStatistics(false);
        cfg.setL1CacheEnabled(false);
        cfg.setWriteSkewCheck(false);
        cfg.setInvocationBatchingEnabled(true);
        return TestCacheManagerFactory.createCacheManager((GlobalConfiguration)globalConfiguration, (Configuration)cfg, (boolean)true);
    }

    public static void initializeDirectory(Directory directory) throws IOException {
        IndexWriter iwriter = new IndexWriter(directory, LuceneSettings.analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
        iwriter.setUseCompoundFile(false);
        iwriter.commit();
        iwriter.close();
        IndexSearcher searcher = new IndexSearcher(directory, true);
        searcher.close();
    }
}

