/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.testng.Assert;

public class DirectoryIntegrityCheck {
    public static void verifyDirectoryStructure(Cache<CacheKey, Object> cache, String indexName) {
        Set fileList = (Set)cache.get((Object)new FileListCacheKey(indexName));
        Assert.assertNotNull((Object)fileList);
        int fileListCacheKeyInstances = 0;
        for (CacheKey key : cache.keySet()) {
            Object value;
            if (key instanceof ChunkCacheKey) {
                ChunkCacheKey existingChunkKey = (ChunkCacheKey)key;
                String filename = existingChunkKey.getFileName();
                Assert.assertEquals((String)existingChunkKey.getIndexName(), (String)indexName);
                Assert.assertTrue((boolean)fileList.contains(filename));
                Object value2 = cache.get((Object)existingChunkKey);
                Assert.assertNotNull((Object)value2);
                Assert.assertTrue((boolean)(value2 instanceof byte[]));
                byte[] buffer = (byte[])cache.get((Object)existingChunkKey);
                Assert.assertTrue((buffer.length != 0 ? 1 : 0) != 0);
                continue;
            }
            if (key instanceof FileCacheKey) {
                FileCacheKey fileCacheKey = (FileCacheKey)key;
                Assert.assertEquals((String)fileCacheKey.getIndexName(), (String)indexName);
                Assert.assertFalse((boolean)fileCacheKey.isLockKey());
                Assert.assertTrue((boolean)fileList.contains(fileCacheKey.getFileName()), (String)(fileCacheKey + " should not have existed"));
                value = cache.get((Object)fileCacheKey);
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof FileMetadata));
                FileMetadata metadata = (FileMetadata)value;
                long totalFileSize = metadata.getSize();
                long actualFileSize = DirectoryIntegrityCheck.deepCountFileSize(fileCacheKey, cache);
                continue;
            }
            if (key instanceof FileListCacheKey) {
                Assert.assertEquals((int)1, (int)(++fileListCacheKeyInstances));
                continue;
            }
            if (key instanceof FileReadLockKey) {
                FileReadLockKey readLockKey = (FileReadLockKey)key;
                Assert.assertEquals((String)readLockKey.getIndexName(), (String)indexName);
                Assert.assertTrue((boolean)fileList.contains(readLockKey.getFileName()), (String)(readLockKey + " should not have existed"));
                value = cache.get((Object)readLockKey);
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof Integer));
                int readLockCount = (Integer)value;
                Assert.assertEquals((int)readLockCount, (int)1, (String)(" for FileReadLockKey " + readLockKey));
                continue;
            }
            Assert.fail((String)("an unexpected key was found in the cache having key type " + key.getClass() + " toString:" + key));
        }
    }

    public static long deepCountFileSize(FileCacheKey fileCacheKey, Cache<CacheKey, Object> cache) {
        String indexName = fileCacheKey.getIndexName();
        String fileName = fileCacheKey.getFileName();
        long accumulator = 0L;
        int i = 0;
        ChunkCacheKey chunkKey;
        byte[] buffer;
        while ((buffer = (byte[])cache.get((Object)(chunkKey = new ChunkCacheKey(indexName, fileName, i)))) != null) {
            accumulator += (long)buffer.length;
            ++i;
        }
        return accumulator;
    }
}

