/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.profiling.LuceneReaderThread;
import org.infinispan.lucene.profiling.LuceneWriterThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.ClusteredCacheFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.PerformanceCompareStressTest", sequential=true)
public class PerformanceCompareStressTest {
    private static final Log log = LogFactory.getLog(PerformanceCompareStressTest.class);
    private static final int THREADS = 5;
    private static final String indexName = "iname";
    private static final long DURATION_MS = 100000L;
    private static final ClusteredCacheFactory cacheFactory = new ClusteredCacheFactory(CacheTestSupport.createTestConfiguration());

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        this.testDirectory((Directory)dir, "RAMDirectory");
    }

    @Test(enabled=false)
    public void profileTestFSDirectory() throws InterruptedException, IOException {
        File indexDir = new File(new File("."), "tempindex");
        indexDir.mkdirs();
        FSDirectory dir = FSDirectory.open((File)indexDir);
        this.testDirectory((Directory)dir, "FSDirectory");
    }

    @Test
    public void profileTestInfinispanDirectory() throws InterruptedException, IOException {
        Cache<CacheKey, Object> cache = cacheFactory.createClusteredCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, indexName);
        this.testDirectory((Directory)dir, "InfinispanClustered");
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheContainer cacheContainer = CacheTestSupport.createLocalCacheManager();
        try {
            Cache cache = cacheContainer.getCache();
            InfinispanDirectory dir = new InfinispanDirectory(cache, indexName);
            this.testDirectory((Directory)dir, "InfinispanLocal");
            DirectoryIntegrityCheck.verifyDirectoryStructure((Cache<CacheKey, Object>)cache, indexName);
        }
        finally {
            cacheContainer.stop();
        }
    }

    private void testDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        SharedState state = new SharedState(200000);
        CacheTestSupport.initializeDirectory(dir);
        ExecutorService e = Executors.newFixedThreadPool(6);
        for (int i = 0; i < 5; ++i) {
            e.execute(new LuceneReaderThread(dir, state));
        }
        e.execute(new LuceneWriterThread(dir, state));
        e.shutdown();
        state.startWaitingThreads();
        Thread.sleep(100000L);
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        state.quit();
        boolean terminatedCorrectly = e.awaitTermination(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)terminatedCorrectly);
        System.out.println("Test " + testLabel + " run in " + 100000L + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
    }

    @BeforeClass
    public static void beforeTest() {
        cacheFactory.start();
    }

    @AfterClass
    public static void afterTest() {
        cacheFactory.stop();
    }
}

