/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.Serializable;
import org.infinispan.lucene.CacheKey;

final class FileReadLockKey
implements Serializable,
CacheKey {
    private static final long serialVersionUID = 7789410500198851940L;
    private final String indexName;
    private final String fileName;
    private final int hashCode;

    FileReadLockKey(String indexName, String fileName) {
        if (indexName == null) {
            throw new IllegalArgumentException("indexName shall not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName shall not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        result = 31 * result + this.indexName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileReadLockKey.class != obj.getClass()) {
            return false;
        }
        FileReadLockKey other = (FileReadLockKey)obj;
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "FileReadLockKey{fileName=" + this.fileName + ", indexName=" + this.indexName + "} ";
    }
}

