/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class BaseLuceneLock
extends Lock {
    private static final Log log = LogFactory.getLog(BaseLuceneLock.class);
    private static final Flag[] lockFlags = new Flag[]{Flag.SKIP_CACHE_STORE};
    private final AdvancedCache<CacheKey, Object> cache;
    private final String lockName;
    private final String indexName;
    private final FileCacheKey keyOfLock;

    BaseLuceneLock(Cache<CacheKey, Object> cache, String indexName, String lockName) {
        this.cache = cache.getAdvancedCache();
        this.lockName = lockName;
        this.indexName = indexName;
        this.keyOfLock = new FileCacheKey(indexName, lockName, true);
    }

    public boolean obtain() throws IOException {
        Object previousValue = this.cache.withFlags(lockFlags).putIfAbsent((Object)this.keyOfLock, (Object)this.keyOfLock);
        if (previousValue == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Lock: {0} acquired for index: {1}", new Object[]{this.lockName, this.indexName});
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Lock: {0} not aquired for index: {1}, was taken already.", new Object[]{this.lockName, this.indexName});
        }
        return false;
    }

    public void release() throws IOException {
        this.clearLock();
    }

    public void clearLock() {
        Object previousValue = this.cache.withFlags(lockFlags).remove((Object)this.keyOfLock);
        if (previousValue != null && log.isTraceEnabled()) {
            log.trace((Object)"Lock removed for index: {0}", new Object[]{this.indexName});
        }
    }

    public boolean isLocked() {
        boolean locked = this.cache.withFlags(lockFlags).containsKey((Object)this.keyOfLock);
        return locked;
    }
}

