/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.testutils.ClusteredCacheFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.DynamicClusterIndexStressTest", enabled=false, description="This is a 'manual' test and should only be enabled and run when attached to a profiler.")
public class DynamicClusterIndexStressTest {
    private static final int TOTAL_NODES_TO_CREATE = 1000;
    private static final int NODE_EXISTING_MILLISECONDS = 60000;
    private static final int TIME_BETWEEN_NODE_CREATIONS = 1000;
    private static final int CONCURRENCY_LIMIT = 10;
    private static final int STRING_POOL_SIZE = 1000;
    private static final Analyzer anyAnalyzer = new SimpleAnalyzer();
    private final BlockingDeque<String> stringsInIndex = new LinkedBlockingDeque<String>();
    private final BlockingDeque<String> stringsOutOfIndex = new LinkedBlockingDeque<String>();
    private final ClusteredCacheFactory cacheFactory = new ClusteredCacheFactory(CacheTestSupport.createTestConfiguration());
    private volatile boolean failed = false;
    private volatile String failureMessage = "";

    private void createIndex(Cache<CacheKey, Object> cache) throws CorruptIndexException, LockObtainFailedException, IOException {
        InfinispanDirectory directory = new InfinispanDirectory(cache, "indexName");
        IndexWriter iwriter = new IndexWriter((Directory)directory, anyAnalyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
        iwriter.commit();
        iwriter.close();
        IndexSearcher searcher = new IndexSearcher((Directory)directory, true);
        searcher.close();
        System.out.println("Index created by " + DynamicClusterIndexStressTest.buildName(cache));
        InfinispanDirectory directory2 = new InfinispanDirectory(cache, "indexName");
        IndexSearcher searcher2 = new IndexSearcher((Directory)directory2, true);
        searcher2.close();
    }

    private void runMoreNodes() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; !this.failed && i < 1000; ++i) {
            executor.execute(new LuceneUserThread());
            Thread.sleep(1000L);
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        Assert.assertTrue((!this.failed ? 1 : 0) != 0, (String)this.failureMessage);
    }

    public void testWithoutRehashing() throws InterruptedException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        Cache[] caches = new Cache[10];
        for (i = 0; i < 10; ++i) {
            caches[i] = this.cacheFactory.createClusteredCacheWaitingForNodesView(i + 1);
        }
        for (i = 0; i < 10; ++i) {
            Thread.sleep(250L);
            DynamicClusterIndexStressTest.cleanup((Cache<CacheKey, Object>)caches[i]);
        }
    }

    private static String buildName(Cache cache) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cache.getCacheManager();
        return Thread.currentThread().getName() + "[" + cacheManager.getAddress().toString() + "]";
    }

    @BeforeClass
    public void beforeTest() {
        this.cacheFactory.start();
    }

    @AfterClass
    public void afterTest() {
        this.cacheFactory.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup(Cache<CacheKey, Object> cache) {
        try {
            TestingUtil.killCaches((Cache[])new Cache[]{cache});
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cache.getCacheManager()});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cache.getCacheManager()});
    }

    private class LuceneUserThread
    implements Runnable {
        private Directory directory;

        private LuceneUserThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DynamicClusterIndexStressTest.this.failed) {
                return;
            }
            String name = "";
            try {
                Cache<CacheKey, Object> cache = DynamicClusterIndexStressTest.this.cacheFactory.createClusteredCache();
                try {
                    name = DynamicClusterIndexStressTest.buildName(cache);
                    this.directory = new InfinispanDirectory(cache, "indexName");
                    System.out.println("Created Directory in " + name);
                    try {
                        this.runTest();
                    }
                    catch (Exception e) {
                        System.out.println("Error in " + name);
                        e.printStackTrace();
                        DynamicClusterIndexStressTest.this.failed = true;
                        DynamicClusterIndexStressTest.this.failureMessage = e.getMessage();
                    }
                }
                finally {
                    DynamicClusterIndexStressTest.cleanup((Cache<CacheKey, Object>)cache);
                }
            }
            catch (InterruptedException e) {
                DynamicClusterIndexStressTest.this.failed = true;
                DynamicClusterIndexStressTest.this.failureMessage = e.getMessage();
            }
            finally {
                System.out.println("Leaving thread " + name);
            }
        }

        private void runTest() throws CorruptIndexException, IOException {
            long finishTime = System.currentTimeMillis() + 60000L;
            while (!DynamicClusterIndexStressTest.this.failed && System.currentTimeMillis() < finishTime) {
                this.verifyStringsExistInIndex();
                this.addSomeStrings();
            }
        }

        private void addSomeStrings() throws CorruptIndexException, LockObtainFailedException, IOException {
            HashSet strings = new HashSet();
            DynamicClusterIndexStressTest.this.stringsOutOfIndex.drainTo(strings, 5);
            IndexWriter iwriter = new IndexWriter(this.directory, anyAnalyzer, false, IndexWriter.MaxFieldLength.UNLIMITED);
            for (String term : strings) {
                Document doc = new Document();
                doc.add((Fieldable)new Field("main", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
                iwriter.addDocument(doc);
            }
            iwriter.commit();
            DynamicClusterIndexStressTest.this.stringsInIndex.addAll(strings);
            iwriter.close();
        }

        private void verifyStringsExistInIndex() throws CorruptIndexException, IOException {
            HashSet strings = new HashSet();
            DynamicClusterIndexStressTest.this.stringsInIndex.drainTo(strings, 50);
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            for (String term : strings) {
                TermQuery query = new TermQuery(new Term("main", term));
                TopDocs docs = searcher.search((Query)query, null, 1);
                if (docs.totalHits == 1) continue;
                DynamicClusterIndexStressTest.this.failed = true;
                DynamicClusterIndexStressTest.this.failureMessage = "couldn't find expected term in index";
            }
            DynamicClusterIndexStressTest.this.stringsInIndex.addAll(strings);
        }
    }
}

