/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.testutils;

import org.testng.annotations.Test;

public class RepeatableLongByteSequence {
    private byte lastUsedValue = (byte)-1;
    private byte currentMax = 1;
    private byte currentMin = (byte)-1;
    private boolean rising = true;

    public byte nextByte() {
        byte next;
        if (this.rising) {
            this.lastUsedValue = (byte)(this.lastUsedValue + 1);
            next = this.lastUsedValue;
            if (next == this.currentMax) {
                this.rising = false;
                this.currentMax = (byte)(this.currentMax + 1);
            }
        } else {
            this.lastUsedValue = (byte)(this.lastUsedValue - 1);
            next = this.lastUsedValue;
            if (next == this.currentMin) {
                this.rising = true;
                this.currentMin = (byte)(this.currentMin - 1);
            }
        }
        return next;
    }

    public void nextBytes(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.nextByte();
        }
    }

    @Test(description="To verify the RepeatableLongByteSequence meets the requirement of producing always the same values when using the single nextByte()")
    public void verifyRepeatability() {
        RepeatableLongByteSequence src1 = new RepeatableLongByteSequence();
        RepeatableLongByteSequence src2 = new RepeatableLongByteSequence();
        for (int i = 0; i < 1000; ++i) {
            assert (src1.nextByte() == src2.nextByte());
        }
    }

    @Test(description="To verify the RepeatableLongByteSequence meets the requirement of producing always the same values when using the multivalued nextBytes()")
    public void verifyEquality() {
        RepeatableLongByteSequence src1 = new RepeatableLongByteSequence();
        RepeatableLongByteSequence src2 = new RepeatableLongByteSequence();
        int arrayLength = 10;
        byte[] b = new byte[10];
        for (int i = 0; i < 1000; ++i) {
            if (i % 10 == 0) {
                src1.nextBytes(b);
            }
            assert (b[i % 10] == src2.nextByte());
        }
    }
}

