/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.Serializable;
import org.infinispan.lucene.CacheKey;

public final class FileCacheKey
implements Serializable,
CacheKey {
    private static final long serialVersionUID = -228474937509042691L;
    private final boolean isLockKey;
    private final String indexName;
    private final String fileName;
    private final int hashCode;

    public FileCacheKey(String indexName, String fileName) {
        this(indexName, fileName, false);
    }

    public FileCacheKey(String indexName, String fileName, boolean isLockKey) {
        this.indexName = indexName;
        this.fileName = fileName;
        this.isLockKey = isLockKey;
        this.hashCode = this.generatedHashCode();
    }

    public boolean isLockKey() {
        return this.isLockKey;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.indexName == null ? 0 : this.indexName.hashCode());
        result = 31 * result + (this.isLockKey ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileCacheKey.class != obj.getClass()) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.indexName == null ? other.indexName != null : !this.indexName.equals(other.indexName)) {
            return false;
        }
        return this.isLockKey == other.isLockKey;
    }

    public String toString() {
        return "FileCacheKey{fileName='" + this.fileName + "', indexName='" + this.indexName + "', isLockKey=" + this.isLockKey + '}';
    }
}

