/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.config.Configuration;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.SimpleLuceneTest")
public class SimpleLuceneTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = CacheTestSupport.createTestConfiguration();
        this.createClusteredCaches(2, "lucene", configuration);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException {
        InfinispanDirectory dirA = new InfinispanDirectory(this.cache(0, "lucene"), "indexName");
        InfinispanDirectory dirB = new InfinispanDirectory(this.cache(1, "lucene"), "indexName");
        CacheTestSupport.writeTextToIndex((Directory)dirA, 0, "hi from node A");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "hi", 0);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "hi", 0);
        CacheTestSupport.writeTextToIndex((Directory)dirB, 1, "hello node A, how are you?");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "node", 1, 0);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "node", 1, 0);
        CacheTestSupport.removeByTerm((Directory)dirA, "from");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "node", 1);
        dirA.close();
        dirB.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache(0, "lucene"), "indexName");
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache(1, "lucene"), "indexName");
    }

    @Test(description="Verifies the caches can be reused after a Directory close")
    public void testCacheReuse() throws IOException {
        this.testIndexWritingAndFinding();
        this.cache(0, "lucene").clear();
        this.testIndexWritingAndFinding();
    }
}

