/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.profiling.LuceneReaderThread;
import org.infinispan.lucene.profiling.LuceneWriterThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.PerformanceCompareStressTest", sequential=true)
public class PerformanceCompareStressTest {
    private static final int DICTIONARY_SIZE = 800000;
    private static final int READER_THREADS = 5;
    private static final int WRITER_THREADS = 1;
    private static final String indexName = "tempIndexName";
    private static final long DURATION_MS = 3600000L;
    private Cache cache;
    private EmbeddedCacheManager cacheFactory;

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "RAMDirectory");
    }

    @Test
    public void profileTestFSDirectory() throws InterruptedException, IOException {
        File indexDir = new File(new File("."), indexName);
        boolean directoriesCreated = indexDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for FSDirectory test";
        FSDirectory dir = FSDirectory.open((File)indexDir);
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "FSDirectory");
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelayZero() throws Exception {
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, indexName);
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "InfinispanClustered-delayedIO:0");
        this.verifyDirectoryState();
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelay4() throws Exception {
        TestingUtil.setDelayForCache((Cache)this.cache, (int)4, (int)4);
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, indexName);
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "InfinispanClustered-delayedIO:4");
        this.verifyDirectoryState();
    }

    @Test
    public void profileTestInfinispanDirectoryWithHighNetworkDelay40() throws Exception {
        TestingUtil.setDelayForCache((Cache)this.cache, (int)40, (int)40);
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, indexName);
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "InfinispanClustered-delayedIO:40");
        this.verifyDirectoryState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheContainer cacheContainer = CacheTestSupport.createLocalCacheManager();
        try {
            this.cache = cacheContainer.getCache();
            InfinispanDirectory dir = new InfinispanDirectory(this.cache, indexName);
            PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "InfinispanLocal");
            this.verifyDirectoryState();
        }
        finally {
            cacheContainer.stop();
        }
    }

    @Test(enabled=false)
    public static void stressTestDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        int i;
        SharedState state = new SharedState(800000);
        CacheTestSupport.initializeDirectory(dir);
        ExecutorService e = Executors.newFixedThreadPool(6);
        for (i = 0; i < 5; ++i) {
            e.execute(new LuceneReaderThread(dir, state));
        }
        for (i = 0; i < 1; ++i) {
            e.execute(new LuceneWriterThread(dir, state));
        }
        e.shutdown();
        state.startWaitingThreads();
        Thread.sleep(3600000L);
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        state.quit();
        boolean terminatedCorrectly = e.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)terminatedCorrectly);
        System.out.println("Test " + testLabel + " run in " + 3600000L + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
    }

    @BeforeMethod
    public void beforeTest() {
        this.cacheFactory = TestCacheManagerFactory.createClusteredCacheManager((Configuration)CacheTestSupport.createTestConfiguration());
        this.cacheFactory.start();
        this.cache = this.cacheFactory.getCache();
        this.cache.clear();
    }

    @AfterMethod
    public void afterTest() {
        TestingUtil.killCaches((Cache[])new Cache[]{this.cache});
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheFactory});
        TestingUtil.recursiveFileRemove((String)indexName);
    }

    private void verifyDirectoryState() {
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache, indexName, true);
    }
}

