/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLockerTest;
import org.infinispan.lucene.readlocks.LocalLockMergingSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.LocalLockMergingSegmentReadLockerTest")
public class LocalLockMergingSegmentReadLockerTest
extends DistributedSegmentReadLockerTest {
    @Override
    @Test
    public void testIndexWritingAndFinding() throws IOException {
        this.verifyBoth(this.cache0, this.cache1);
        IndexOutput indexOutput = this.dirA.createOutput("readme.txt");
        indexOutput.writeString("no need to write, nobody ever will read this");
        indexOutput.flush();
        indexOutput.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, true);
        IndexInput firstOpenOnB = this.dirB.openInput("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 2, true);
        this.dirA.deleteFile("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        IndexInput cloneOfFirstOpenOnB = (IndexInput)firstOpenOnB.clone();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        cloneOfFirstOpenOnB.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        IndexInput firstOpenOnA = this.dirA.openInput("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        IndexInput secondOpenOnA = this.dirA.openInput("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        firstOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        secondOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        firstOpenOnB.close();
        this.assertFileNotExists("readme.txt");
        this.dirA.close();
        this.dirB.close();
        this.verifyBoth(this.cache0, this.cache1);
    }

    @Override
    Directory createDirectory(Cache cache) {
        return new InfinispanDirectory(cache, "indexName", 6, (SegmentReadLocker)new LocalLockMergingSegmentReadLocker(cache, "indexName"));
    }
}

