/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.locking.BaseLuceneLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BaseLockFactory
extends LockFactory {
    private static final Log log = LogFactory.getLog(BaseLockFactory.class);
    static final String DEF_LOCK_NAME = "write.lock";
    private final Cache cache;
    private final String indexName;
    private final BaseLuceneLock defLock;

    public BaseLockFactory(Cache cache, String indexName) {
        this.cache = cache;
        this.indexName = indexName;
        this.defLock = new BaseLuceneLock(cache, indexName, DEF_LOCK_NAME);
    }

    public BaseLuceneLock makeLock(String lockName) {
        BaseLuceneLock lock = DEF_LOCK_NAME.equals(lockName) ? this.defLock : new BaseLuceneLock(this.cache, this.indexName, lockName);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Lock prepared, not acquired: {0} for index {1}", new Object[]{lockName, this.indexName});
        }
        return lock;
    }

    public void clearLock(String lockName) throws IOException {
        if (DEF_LOCK_NAME.equals(lockName)) {
            this.defLock.clearLock();
        } else {
            new BaseLuceneLock(this.cache, this.indexName, lockName).clearLock();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Removed lock: {0} for index {1}", new Object[]{lockName, this.indexName});
        }
    }
}

