/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.testng.Assert;

public class DirectoryIntegrityCheck {
    public static void verifyDirectoryStructure(Cache cache, String indexName) {
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, indexName, false);
    }

    public static void verifyDirectoryStructure(Cache cache, String indexName, boolean wasAStressTest) {
        Set fileList = (Set)cache.get((Object)new FileListCacheKey(indexName));
        Assert.assertNotNull((Object)fileList);
        int fileListCacheKeyInstances = 0;
        for (Object key : cache.keySet()) {
            Object value;
            String filename;
            if (key instanceof ChunkCacheKey) {
                ChunkCacheKey existingChunkKey = (ChunkCacheKey)key;
                filename = existingChunkKey.getFileName();
                Assert.assertEquals((String)existingChunkKey.getIndexName(), (String)indexName);
                value = cache.get((Object)existingChunkKey);
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof byte[]));
                byte[] buffer = (byte[])cache.get((Object)existingChunkKey);
                Assert.assertTrue((buffer.length != 0 ? 1 : 0) != 0);
                continue;
            }
            if (key instanceof FileCacheKey) {
                FileCacheKey fileCacheKey = (FileCacheKey)key;
                Assert.assertEquals((String)fileCacheKey.getIndexName(), (String)indexName);
                filename = fileCacheKey.getFileName();
                value = cache.get((Object)fileCacheKey);
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof FileMetadata));
                FileMetadata metadata = (FileMetadata)value;
                long totalFileSize = metadata.getSize();
                long actualFileSize = DirectoryIntegrityCheck.deepCountFileSize(fileCacheKey, cache);
                Assert.assertEquals((long)actualFileSize, (long)totalFileSize);
                Assert.assertTrue((boolean)fileList.contains(fileCacheKey.getFileName()), (String)(fileCacheKey + " should not have existed"));
                continue;
            }
            if (key instanceof FileListCacheKey) {
                Assert.assertEquals((int)1, (int)(++fileListCacheKeyInstances));
                continue;
            }
            if (key instanceof FileReadLockKey) {
                FileReadLockKey readLockKey = (FileReadLockKey)key;
                Assert.assertEquals((String)readLockKey.getIndexName(), (String)indexName);
                Object value2 = cache.get((Object)readLockKey);
                Assert.assertTrue((cache.get((Object)new FileCacheKey(indexName, readLockKey.getFileName())) != null ? 1 : 0) != 0, (String)(key + " left over from deleted " + readLockKey.getFileName()));
                Assert.assertTrue((cache.get((Object)new ChunkCacheKey(indexName, readLockKey.getFileName(), 0)) != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)fileList.contains(readLockKey.getFileName()), (String)("readlock still exists but the file was deleted: " + readLockKey));
                Assert.assertTrue((value2 == null || value2.equals(1) ? 1 : 0) != 0);
                continue;
            }
            Assert.fail((String)("an unexpected key was found in the cache having key type " + key.getClass() + " toString:" + key));
        }
    }

    private static void verifyReadlockExists(Cache cache, String indexName, String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(indexName, filename);
        Object readLockValue = cache.get((Object)readLockKey);
        Assert.assertNotNull((Object)readLockValue);
        Assert.assertTrue((boolean)(readLockValue instanceof Integer));
        int v = (Integer)readLockValue;
        Assert.assertTrue((v > 1 ? 1 : 0) != 0, (String)("readlock exists for unregistered file of unexpected value: " + v + " for file: " + filename));
    }

    public static long deepCountFileSize(FileCacheKey fileCacheKey, Cache cache) {
        String indexName = fileCacheKey.getIndexName();
        String fileName = fileCacheKey.getFileName();
        long accumulator = 0L;
        int i = 0;
        ChunkCacheKey chunkKey;
        byte[] buffer;
        while ((buffer = (byte[])cache.get((Object)(chunkKey = new ChunkCacheKey(indexName, fileName, i)))) != null) {
            accumulator += (long)buffer.length;
            ++i;
        }
        return accumulator;
    }

    public static void assertFileNotExists(Cache cache, String indexName, String fileName) {
        Set fileList = (Set)cache.get((Object)new FileListCacheKey(indexName));
        Assert.assertNotNull((Object)fileList);
        Assert.assertFalse((boolean)fileList.contains(fileName));
        Assert.assertNull((Object)cache.get((Object)new FileCacheKey(indexName, fileName)), (String)"metadata found for deleted file");
        for (int i = 0; i < 10; ++i) {
            ChunkCacheKey key = new ChunkCacheKey(indexName, fileName, i);
            Assert.assertNull((Object)cache.get((Object)key), (String)("a chunk was found for a deleted file: " + key));
        }
    }

    public static void assertFileExistsHavingRLCount(Cache cache, String fileName, String indexName, int expectedReadcount, int chunkSize, boolean expectRegisteredInFat) {
        Set fileList = (Set)cache.get((Object)new FileListCacheKey(indexName));
        Assert.assertNotNull((Object)fileList);
        Assert.assertTrue((fileList.contains(fileName) == expectRegisteredInFat ? 1 : 0) != 0);
        FileMetadata metadata = (FileMetadata)cache.get((Object)new FileCacheKey(indexName, fileName));
        Assert.assertNotNull((Object)metadata);
        long totalFileSize = metadata.getSize();
        int chunkNumbers = (int)(totalFileSize / (long)chunkSize);
        for (int i = 0; i < chunkNumbers; ++i) {
            Assert.assertNotNull((Object)cache.get((Object)new ChunkCacheKey(indexName, fileName, i)));
        }
        FileReadLockKey readLockKey = new FileReadLockKey(indexName, fileName);
        Object value = cache.get((Object)readLockKey);
        if (expectedReadcount == 1) {
            Assert.assertTrue((value == null || Integer.valueOf(1).equals(value) ? 1 : 0) != 0, (String)("readlock value is " + value));
        } else {
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)(value instanceof Integer));
            int v = (Integer)value;
            Assert.assertEquals((int)v, (int)expectedReadcount);
        }
    }
}

