/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

public class DistributedSegmentReadLocker
implements SegmentReadLocker {
    private final AdvancedCache cache;
    private final String indexName;

    public DistributedSegmentReadLocker(Cache cache, String indexName) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null");
        }
        if (indexName == null) {
            throw new IllegalArgumentException("index name must not be null");
        }
        this.indexName = indexName;
        this.cache = cache.getAdvancedCache();
    }

    @Override
    public void deleteOrReleaseReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        int newValue = 0;
        boolean done = false;
        Object lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        while (!done) {
            if (lockValue == null) {
                lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putIfAbsent((Object)readLockKey, (Object)0);
                done = null == lockValue;
                continue;
            }
            int refCount = (Integer)lockValue;
            newValue = refCount - 1;
            done = this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)readLockKey, (Object)refCount, (Object)newValue);
            if (done) continue;
            lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        }
        if (newValue == 0) {
            DistributedSegmentReadLocker.realFileDelete(readLockKey, this.cache);
        }
    }

    @Override
    public boolean aquireReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        Object lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        boolean done = false;
        while (!done) {
            FileCacheKey fileKey;
            if (lockValue != null) {
                int refCount = (Integer)lockValue;
                if (refCount == 0) {
                    return false;
                }
                Integer newValue = refCount + 1;
                done = this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)readLockKey, lockValue, (Object)newValue);
                if (done) continue;
                lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
                continue;
            }
            lockValue = this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putIfAbsent((Object)readLockKey, (Object)2);
            done = null == lockValue;
            if (!done || this.cache.get((Object)(fileKey = new FileCacheKey(this.indexName, filename))) != null) continue;
            this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
            return false;
        }
        return true;
    }

    static void realFileDelete(FileReadLockKey readLockKey, AdvancedCache cache) {
        String indexName = readLockKey.getIndexName();
        String filename = readLockKey.getFileName();
        FileCacheKey key = new FileCacheKey(indexName, filename);
        boolean batch = cache.startBatch();
        FileMetadata file = (FileMetadata)cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).remove((Object)key);
        if (file != null) {
            for (int i = 0; i < file.getNumberOfChunks(); ++i) {
                ChunkCacheKey chunkKey = new ChunkCacheKey(indexName, filename, i);
                cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)chunkKey);
            }
            cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)key);
        }
        cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
        if (batch) {
            cache.endBatch(true);
        }
    }
}

