/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.Serializable;

public final class ChunkCacheKey
implements Serializable {
    private static final long serialVersionUID = 4429712073623290126L;
    private final int chunkId;
    private final String indexName;
    private final String fileName;
    private final int hashCode;

    public ChunkCacheKey(String indexName, String fileName, int chunkId) {
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.chunkId = chunkId;
        this.hashCode = this.generatedHashCode();
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        int prime = 31;
        int result = 31 + this.chunkId;
        result = 31 * result + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ChunkCacheKey.class != obj.getClass()) {
            return false;
        }
        ChunkCacheKey other = (ChunkCacheKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return this.fileName + "|" + this.chunkId + "|" + this.indexName;
    }
}

