/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import javax.transaction.TransactionManager;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lucene.locking.TransactionalSharedLuceneLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalLockFactory
extends LockFactory {
    private static final Log log = LogFactory.getLog(TransactionalLockFactory.class);
    private static final String DEF_LOCK_NAME = "write.lock";
    private final Cache cache;
    private final String indexName;
    private final TransactionManager tm;
    private final TransactionalSharedLuceneLock defLock;

    public TransactionalLockFactory(Cache cache, String indexName) {
        this.cache = cache;
        this.indexName = indexName;
        this.tm = cache.getAdvancedCache().getTransactionManager();
        if (this.tm == null) {
            ComponentStatus status = cache.getAdvancedCache().getComponentRegistry().getStatus();
            if (status.equals((Object)ComponentStatus.RUNNING)) {
                throw new CacheException("Failed looking up TransactionManager. Check if any transaction manager is associated with Infinispan cache: '" + cache.getName() + "'");
            }
            throw new CacheException("Failed looking up TransactionManager: the cache is not running");
        }
        this.defLock = new TransactionalSharedLuceneLock(cache, indexName, DEF_LOCK_NAME, this.tm);
    }

    public TransactionalSharedLuceneLock makeLock(String lockName) {
        TransactionalSharedLuceneLock lock = DEF_LOCK_NAME.equals(lockName) ? this.defLock : new TransactionalSharedLuceneLock(this.cache, this.indexName, lockName, this.tm);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Lock prepared, not acquired: {0} for index {1}", new Object[]{lockName, this.indexName});
        }
        return lock;
    }

    public void clearLock(String lockName) throws IOException {
        if (DEF_LOCK_NAME.equals(lockName)) {
            this.defLock.clearLockSuspending();
        } else {
            new TransactionalSharedLuceneLock(this.cache, this.indexName, lockName, this.tm).clearLockSuspending();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Removed lock: {0} for index {1}", new Object[]{lockName, this.indexName});
        }
    }
}

