/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class FileListCacheKey
implements Serializable {
    private static final long serialVersionUID = 8965108175527988255L;
    private final String indexName;
    private final int hashCode;

    public FileListCacheKey(String indexName) {
        this.indexName = indexName;
        this.hashCode = this.generatedHashCode();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        return 31 + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileListCacheKey.class != obj.getClass()) {
            return false;
        }
        FileListCacheKey other = (FileListCacheKey)obj;
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "*|" + this.indexName;
    }

    public static class Externalizer
    extends AbstractExternalizer<FileListCacheKey> {
        public void writeObject(ObjectOutput output, FileListCacheKey key) throws IOException {
            output.writeUTF(key.indexName);
        }

        public FileListCacheKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String indexName = input.readUTF();
            return new FileListCacheKey(indexName);
        }

        public Integer getId() {
            return 1300;
        }

        public Set<Class<? extends FileListCacheKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileListCacheKey.class});
        }
    }
}

