/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class FileReadLockKey
implements Serializable {
    private static final long serialVersionUID = 7789410500198851940L;
    private final String indexName;
    private final String fileName;
    private final int hashCode;

    public FileReadLockKey(String indexName, String fileName) {
        if (indexName == null) {
            throw new IllegalArgumentException("indexName shall not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName shall not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.hashCode = this.generateHashCode();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileReadLockKey.class != obj.getClass()) {
            return false;
        }
        FileReadLockKey other = (FileReadLockKey)obj;
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return this.fileName + "|RL|" + this.indexName;
    }

    public static class Externalizer
    extends AbstractExternalizer<FileReadLockKey> {
        public void writeObject(ObjectOutput output, FileReadLockKey key) throws IOException {
            output.writeUTF(key.indexName);
            output.writeUTF(key.fileName);
        }

        public FileReadLockKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String indexName = input.readUTF();
            String fileName = input.readUTF();
            return new FileReadLockKey(indexName, fileName);
        }

        public Integer getId() {
            return 1304;
        }

        public Set<Class<? extends FileReadLockKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileReadLockKey.class});
        }
    }
}

