/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.store.Directory;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DatabaseStoredIndexTest")
public class DatabaseStoredIndexTest
extends SingleCacheManagerTest {
    private final ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
    private static final String INDEX_NAME = "testing index";
    private final HashMap cacheCopy = new HashMap();

    public DatabaseStoredIndexTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration configuration = CacheTestSupport.createTestConfiguration();
        this.enableTestJdbcStorage(configuration);
        return TestCacheManagerFactory.createClusteredCacheManager((Configuration)configuration);
    }

    private void enableTestJdbcStorage(Configuration configuration) {
        TableManipulation tm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        JdbcStringBasedCacheStoreConfig jdbcStoreConfiguration = new JdbcStringBasedCacheStoreConfig(this.connectionFactoryConfig, tm);
        jdbcStoreConfiguration.setKey2StringMapperClass(LuceneKey2StringMapper.class.getName());
        CacheLoaderManagerConfig loaderManagerConfig = configuration.getCacheLoaderManagerConfig();
        loaderManagerConfig.setPreload(Boolean.valueOf(false));
        loaderManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)jdbcStoreConfiguration);
    }

    @Test
    public void testIndexUsage() throws IOException {
        this.cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, INDEX_NAME);
        CacheTestSupport.writeTextToIndex((Directory)dir, 0, "hello database");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "hello", 0);
        CacheTestSupport.writeTextToIndex((Directory)dir, 1, "you have to store my index segments");
        CacheTestSupport.writeTextToIndex((Directory)dir, 2, "so that I can shut down all nodes");
        CacheTestSupport.writeTextToIndex((Directory)dir, 3, "and restart later keeping the index around");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "index", 1, 3);
        CacheTestSupport.removeByTerm((Directory)dir, "and");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "index", 1);
        dir.close();
        this.cacheCopy.putAll(this.cache);
        this.cache.stop();
        this.cacheManager.stop();
    }

    @Test(dependsOnMethods={"testIndexUsage"})
    public void indexWasStored() throws IOException {
        this.cache = this.cacheManager.getCache();
        assert (this.cache.isEmpty());
        boolean failed = false;
        for (Object key : this.cacheCopy.keySet()) {
            if (key instanceof FileReadLockKey) {
                System.out.println("Key found in store, shouldn't have persisted this or should have cleaned up all readlocks on directory close:" + key);
                failed = true;
                continue;
            }
            Object expected = this.cacheCopy.get(key);
            Object actual = this.cache.get(key);
            if (expected == null && actual == null) continue;
            if (expected instanceof byte[]) {
                expected = Arrays.toString((byte[])expected);
                actual = Arrays.toString((byte[])actual);
            }
            if (expected != null && expected.equals(actual)) continue;
            System.out.println("Failure on key[" + key.toString() + "] expected value:\n\t" + expected + "\tactual value:\n\t" + actual);
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
        Assert.assertEquals((int)this.cacheCopy.keySet().size(), (int)this.cache.keySet().size(), (String)"have a different number of keys");
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, INDEX_NAME);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "index", 1);
        dir.close();
    }
}

