/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DirectoryOnMultipleCachesTest")
public class DirectoryOnMultipleCachesTest {
    private CacheContainer cacheManager;
    private Cache metadataCache;
    private Cache chunkCache;
    private Cache lockCache;

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() {
        this.cacheManager = CacheTestSupport.createLocalCacheManager();
        this.metadataCache = this.cacheManager.getCache("metadata");
        this.chunkCache = this.cacheManager.getCache("chunks");
        this.lockCache = this.cacheManager.getCache("locks");
    }

    @Test
    public void testRunningOnMultipleCaches() throws IOException {
        assert (this.metadataCache != this.chunkCache);
        assert (this.chunkCache != this.lockCache);
        assert (this.lockCache != this.metadataCache);
        InfinispanDirectory dir = new InfinispanDirectory(this.metadataCache, this.chunkCache, this.lockCache, "testingIndex", 100);
        CacheTestSupport.writeTextToIndex((Directory)dir, 0, "hello world");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "hello", 0);
        CacheTestSupport.writeTextToIndex((Directory)dir, 1, "hello solar system");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "hello", 0, 1);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "system", 1);
        CacheTestSupport.optimizeIndex((Directory)dir);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dir, "hello", 0, 1);
        dir.close();
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedChunkCachesUsage() {
        int chunks = 0;
        for (Object key : this.chunkCache.keySet()) {
            ++chunks;
            assert (key.getClass().equals(ChunkCacheKey.class));
            Object value = this.chunkCache.get(key);
            assert (byte[].class.equals(value.getClass()));
        }
        assert (chunks != 0);
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedLockCachesUsage() {
        for (Object key : this.lockCache.keySet()) {
            assert (key.getClass().equals(FileReadLockKey.class));
            assert (this.lockCache.get(key).equals(1));
        }
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedMetadataCachesUsage() {
        int metadata = 0;
        int filelists = 0;
        for (Object key : this.metadataCache.keySet()) {
            Object value = this.metadataCache.get(key);
            if (key.getClass().equals(FileListCacheKey.class)) {
                ++filelists;
                assert (value.getClass().equals(ConcurrentHashSet.class));
                continue;
            }
            if (key.getClass().equals(FileCacheKey.class)) {
                ++metadata;
                assert (value.getClass().equals(FileMetadata.class));
                continue;
            }
            assert (false) : "unexpected type of key in metadata cache: " + key.getClass();
        }
        assert (filelists == 1);
        assert (metadata != 0);
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheManager});
    }
}

