/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;

public final class SingleChunkIndexInput
extends IndexInput {
    private final byte[] buffer;
    private int bufferPosition;

    public SingleChunkIndexInput(AdvancedCache chunksCache, FileCacheKey fileKey, FileMetadata fileMetadata) {
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), 0);
        byte[] b = (byte[])chunksCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
        this.buffer = b == null ? new byte[0] : b;
        this.bufferPosition = 0;
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.bufferPosition;
    }

    public long length() {
        return this.buffer.length;
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.buffer.length) {
            throw new IOException("Read past EOF");
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.buffer.length - this.bufferPosition < len) {
            throw new IOException("Read past EOF");
        }
        System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
        this.bufferPosition += len;
    }

    public void seek(long pos) {
        this.bufferPosition = (int)Math.min(pos, (long)this.buffer.length);
    }
}

