/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.store.Directory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DynamicBufferSizeTest")
public class DynamicBufferSizeTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        Configuration configuration = builder.clustering().cacheMode(CacheMode.LOCAL).invocationBatching().enable().build();
        return TestCacheManagerFactory.createCacheManager((Configuration)configuration);
    }

    @Test
    public void roundingTest() {
        FileMetadata m = new FileMetadata(10);
        Assert.assertEquals((int)0, (int)m.getNumberOfChunks());
        m.setSize(10L);
        Assert.assertEquals((int)1, (int)m.getNumberOfChunks());
        m.setSize(11L);
        Assert.assertEquals((int)2, (int)m.getNumberOfChunks());
        m = new FileMetadata(11);
        m.setSize(11L);
        Assert.assertEquals((int)1, (int)m.getNumberOfChunks());
        m.setSize(22L);
        Assert.assertEquals((int)2, (int)m.getNumberOfChunks());
        m.setSize(31L);
        m = new FileMetadata(10);
        m.setSize(31L);
        Assert.assertEquals((int)4, (int)m.getNumberOfChunks());
    }

    @Test
    public void testReadingFromDifferentlySizedBuffers() throws IOException {
        this.cache = this.cacheManager.getCache();
        InfinispanDirectory dirA = new InfinispanDirectory(this.cache, this.cache, this.cache, "indexName", 7);
        CacheTestSupport.writeTextToIndex((Directory)dirA, 0, "hi from node A");
        InfinispanDirectory dirB = new InfinispanDirectory(this.cache, this.cache, this.cache, "indexName", 8);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "hi", 0);
        CacheTestSupport.writeTextToIndex((Directory)dirB, 1, "index B is sharing the same index but using a differently sized chunk size");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "size", 1);
    }
}

