/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.marshalling.ObjectTable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExternalizersEnabledTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configurationBuilder);
    }

    @Test
    public void testChunkCacheKeyExternalizer() throws IOException {
        ChunkCacheKey key = new ChunkCacheKey("myIndex", "filename", 5, 1000);
        this.verifyExternalizerForType(key, ChunkCacheKey.Externalizer.class);
    }

    @Test
    public void testFileCacheKeyExternalizer() throws IOException {
        FileCacheKey key = new FileCacheKey("myIndex", "fileA.idx");
        this.verifyExternalizerForType(key, FileCacheKey.Externalizer.class);
    }

    @Test
    public void testFileListCacheKeyExternalizer() throws IOException {
        FileListCacheKey key = new FileListCacheKey("myIndex");
        this.verifyExternalizerForType(key, FileListCacheKey.Externalizer.class);
    }

    @Test
    public void testFileMetadataExternalizer() throws IOException {
        FileMetadata key = new FileMetadata(23);
        this.verifyExternalizerForType(key, FileMetadata.Externalizer.class);
    }

    @Test
    public void testFileReadLockKeyExternalizer() throws IOException {
        FileReadLockKey key = new FileReadLockKey("myIndex", "index.lock");
        this.verifyExternalizerForType(key, FileReadLockKey.Externalizer.class);
    }

    private void verifyExternalizerForType(Object keySampleType, Class expectedExcternalizerClass) throws IOException {
        ExternalizerTable externalizerTable = TestingUtil.extractExtTable((CacheContainer)this.cacheManager);
        ObjectTable.Writer objectWriter = externalizerTable.getObjectWriter(keySampleType);
        Assert.assertEquals((String)objectWriter.getClass().toString(), (String)"class org.infinispan.marshall.jboss.ExternalizerTable$ForeignExternalizerAdapter", (String)"Registered Externalizers should be wrapped by a ForeignExternalizerAdapter");
        Assert.assertEquals((String)("class " + objectWriter.toString()), (String)expectedExcternalizerClass.toString(), (String)("Type of delegate used by the adapter doesn't match expected: " + expectedExcternalizerClass.getClass()));
    }
}

