/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.SkipIndexingGuaranteed;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.SimpleLuceneTest")
public class SimpleLuceneTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        this.startClusterNode();
        this.startClusterNode();
    }

    private void startClusterNode() {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(TransactionMode.NON_TRANSACTIONAL);
        configurationBuilder.customInterceptors().addInterceptor().after(NonTransactionalLockingInterceptor.class).interceptor((CommandInterceptor)new SkipIndexingGuaranteed());
        this.createClusteredCaches(1, "lucene", configurationBuilder);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException {
        String indexName = "indexName";
        Cache cache0 = this.cache(0, "lucene");
        Cache cache1 = this.cache(1, "lucene");
        InfinispanDirectory dirA = new InfinispanDirectory(cache0, "indexName");
        InfinispanDirectory dirB = new InfinispanDirectory(cache1, "indexName");
        CacheTestSupport.writeTextToIndex((Directory)dirA, 0, "hi from node A");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "hi", 0);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "hi", 0);
        CacheTestSupport.writeTextToIndex((Directory)dirB, 1, "hello node A, how are you?");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirA, "node", 1, 0);
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "node", 1, 0);
        CacheTestSupport.removeByTerm((Directory)dirA, "from");
        CacheTestSupport.assertTextIsFoundInIds((Directory)dirB, "node", 1);
        dirA.close();
        dirB.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache0, "indexName");
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache1, "indexName");
    }

    @Test(description="Verifies the caches can be reused after a Directory close")
    public void testCacheReuse() throws IOException {
        this.testIndexWritingAndFinding();
        this.cache(0, "lucene").getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).clear();
        this.testIndexWritingAndFinding();
    }
}

