/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.infinispan.lucene.profiling.PerformanceCompareStressTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.CacheStoreStressTest", sequential=true)
public class CacheStoreStressTest
extends SingleCacheManagerTest {
    private final ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
    private static final String indexName = "tempIndexName";

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration configuration = CacheTestSupport.createLegacyTestConfiguration();
        this.enableTestJdbcStorage(configuration);
        return TestCacheManagerFactory.createClusteredCacheManager((Configuration)configuration);
    }

    private void enableTestJdbcStorage(Configuration configuration) {
        TableManipulation tm = UnitTestDatabaseManager.buildStringTableManipulation();
        JdbcStringBasedCacheStoreConfig jdbcStoreConfiguration = new JdbcStringBasedCacheStoreConfig(this.connectionFactoryConfig, tm);
        jdbcStoreConfiguration.setKey2StringMapperClass(LuceneKey2StringMapper.class.getName());
        CacheLoaderManagerConfig loaderManagerConfig = configuration.getCacheLoaderManagerConfig();
        loaderManagerConfig.setPreload(Boolean.TRUE);
        loaderManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)jdbcStoreConfiguration);
    }

    @Test
    public void stressTestOnStore() throws InterruptedException, IOException {
        this.cache = this.cacheManager.getCache();
        assert (this.cache != null);
        InfinispanDirectory dir = new InfinispanDirectory(this.cache, indexName);
        PerformanceCompareStressTest.stressTestDirectory((Directory)dir, "InfinispanClusteredWith-Store");
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache, indexName, true);
    }
}

