/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LuceneUserThread
implements Runnable {
    private static final Log log = LogFactory.getLog(InfinispanDirectory.class);
    protected final Directory directory;
    protected final SharedState state;

    LuceneUserThread(Directory dir, SharedState state) {
        this.directory = dir;
        this.state = state;
    }

    @Override
    public final void run() {
        try {
            this.state.waitForStart();
        }
        catch (InterruptedException e1) {
            this.state.errorManage(e1);
            return;
        }
        while (!this.state.needToQuit()) {
            try {
                this.testLoop();
            }
            catch (Exception e) {
                log.error((Object)"unexpected error", (Throwable)e);
                this.state.errorManage(e);
            }
        }
        try {
            this.cleanup();
        }
        catch (IOException e) {
            log.error((Object)"unexpected error", (Throwable)e);
            this.state.errorManage(e);
        }
    }

    protected abstract void testLoop() throws IOException;

    protected void cleanup() throws IOException {
    }
}

