/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.Arrays;
import junit.framework.Assert;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.Key2StringMapperTest")
public class Key2StringMapperTest {
    final LuceneKey2StringMapper mapper = new LuceneKey2StringMapper();

    @Test
    public void testRegex() {
        Object[] split = LuceneKey2StringMapper.singlePipePattern.split("hello|world");
        Assert.assertTrue((boolean)Arrays.deepEquals(new String[]{"hello", "world"}, split));
    }

    @Test
    public void loadChunkCacheKey() {
        Assert.assertEquals((Object)new ChunkCacheKey("my addressbook", "sgments0.gen", 34, 16000000), (Object)this.mapper.getKeyMapping("sgments0.gen|34|16000000|my addressbook"));
    }

    @Test
    public void loadFileCacheKey() {
        Assert.assertEquals((Object)new FileCacheKey("poems and songs, 3000AC-2000DC", "filename.extension"), (Object)this.mapper.getKeyMapping("filename.extension|M|poems and songs, 3000AC-2000DC"));
    }

    @Test
    public void loadFileListCacheKey() {
        Assert.assertEquals((Object)new FileListCacheKey(""), (Object)this.mapper.getKeyMapping("*|"));
        Assert.assertEquals((Object)new FileListCacheKey("the leaves of Amazonia"), (Object)this.mapper.getKeyMapping("*|the leaves of Amazonia"));
    }

    @Test
    public void loadReadLockKey() {
        Assert.assertEquals((Object)new FileReadLockKey("poems and songs, 3000AC-2000DC", "brushed steel lock"), (Object)this.mapper.getKeyMapping("brushed steel lock|RL|poems and songs, 3000AC-2000DC"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForIllegalKeys() {
        this.mapper.getKeyMapping("|*|the leaves of Amazonia");
    }
}

