/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.cachestore.LuceneCacheLoader;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cacheloader.IndexCacheLoaderTest")
public class IndexCacheLoaderTest {
    private static final String rootDirectoryName = "indexesRootDirTmp";
    private static final int SCALE = 600;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readExistingIndexTest() throws IOException {
        File rootDir = new File(new File("."), rootDirectoryName);
        boolean directoriesCreated = rootDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for test";
        try {
            this.createIndex(rootDir, "index-A", 6000, true);
            this.createIndex(rootDir, "index-B", 12000, false);
            this.verifyIndex(rootDir, "index-A", 6000, true);
            this.verifyIndex(rootDir, "index-B", 12000, false);
        }
        finally {
            TestingUtil.recursiveFileRemove((File)rootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndex(File rootDir, String indexName, int termsAdded, boolean inverted) throws IOException {
        File indexDir = new File(rootDir, indexName);
        FSDirectory directory = FSDirectory.open((File)indexDir);
        try {
            this.verifyOnDirectory((Directory)directory, indexName, termsAdded, inverted);
        }
        finally {
            directory.close();
        }
        EmbeddedCacheManager cacheManager = this.initializeInfinispan(rootDir, indexName);
        try {
            directory = new InfinispanDirectory(cacheManager.getCache(), indexName);
            try {
                this.verifyOnDirectory((Directory)directory, indexName, termsAdded, inverted);
            }
            finally {
                directory.close();
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    private EmbeddedCacheManager initializeInfinispan(File rootDir, String indexName) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.loaders().addLoader().cacheLoader((CacheLoader)new LuceneCacheLoader()).addProperty("location", rootDir.getAbsolutePath()).addProperty("autoChunkSize", "1024");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOnDirectory(Directory directory, String indexName, int termsAdded, boolean inverted) throws IOException {
        IndexReader indexReader = IndexReader.open((Directory)directory);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        try {
            for (int i = 0; i <= termsAdded; ++i) {
                TermQuery queryNotToFind;
                TermQuery queryToFind;
                String term = String.valueOf(i);
                if (i % 2 == 0 ^ inverted) {
                    queryToFind = new TermQuery(new Term("main", term));
                    queryNotToFind = new TermQuery(new Term("secondaryField", term));
                } else {
                    queryToFind = new TermQuery(new Term("secondaryField", term));
                    queryNotToFind = new TermQuery(new Term("main", term));
                }
                TopDocs docs = searcher.search((Query)queryToFind, null, 2);
                assert (docs.totalHits == 1) : "String '" + term + "' should exist but was not found in index";
                docs = searcher.search((Query)queryNotToFind, null, 1);
                assert (docs.totalHits == 0) : "String '" + term + "' should NOT exist but was found in index";
            }
        }
        finally {
            indexReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(File rootDir, String indexName, int termsToAdd, boolean invert) throws IOException {
        File indexDir = new File(rootDir, indexName);
        FSDirectory directory = FSDirectory.open((File)indexDir);
        try {
            CacheTestSupport.initializeDirectory((Directory)directory);
            IndexWriter iwriter = LuceneSettings.openWriter((Directory)directory, 100000);
            try {
                for (int i = 0; i <= termsToAdd; ++i) {
                    Document doc = new Document();
                    String term = String.valueOf(i);
                    if (i % 2 == 0 ^ invert) {
                        doc.add((Fieldable)new Field("main", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
                    } else {
                        doc.add((Fieldable)new Field("secondaryField", term, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                    iwriter.addDocument(doc);
                }
                iwriter.commit();
            }
            finally {
                iwriter.close();
            }
        }
        finally {
            directory.close();
        }
    }
}

