/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.testutils.RepeatableLongByteSequence;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.InfinispanDirectoryIOTest", sequential=true)
public class InfinispanDirectoryIOTest {
    private static final String INDEXNAME = "index";
    private CacheContainer cacheManager;
    private File indexDir = new File(new File("."), "index");

    @BeforeTest
    public void prepareCacheManager() {
        this.cacheManager = CacheTestSupport.createTestCacheManager();
    }

    @AfterTest(alwaysRun=true)
    public void killCacheManager() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheManager});
    }

    @AfterMethod(alwaysRun=true)
    public void clearCache() {
        this.cacheManager.getCache().clear();
        TestingUtil.recursiveFileRemove((File)this.indexDir);
    }

    @Test
    public void testWriteUsingSeekMethod() throws IOException {
        int BUFFER_SIZE = 64;
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 64);
        String fileName = "SomeText.txt";
        IndexOutput io = dir.createOutput(fileName);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        int REPEATABLE_BUFFER_SIZE = 1501;
        for (int i = 0; i < 1501; ++i) {
            io.writeByte(bytesGenerator.nextByte());
        }
        io.flush();
        assert (io.length() == 1501L);
        String someText = "This is some text";
        byte[] someTextAsBytes = "This is some text".getBytes();
        int[] pointers = new int[]{0, 635, 1501, 135};
        for (int i = 0; i < pointers.length; ++i) {
            io.seek((long)pointers[i]);
            io.writeBytes(someTextAsBytes, someTextAsBytes.length);
        }
        io.close();
        bytesGenerator.reset();
        long finalSize = 1501 + someTextAsBytes.length;
        assert (io.length() == finalSize);
        assert (io.length() == DirectoryIntegrityCheck.deepCountFileSize(new FileCacheKey(INDEXNAME, fileName), cache));
        int indexPointer = 0;
        Arrays.sort(pointers);
        byte[] buffer = null;
        int chunkIndex = -1;
        for (int i = 0; i < 1501 + someTextAsBytes.length; ++i) {
            if (i % 64 == 0) {
                buffer = (byte[])cache.get((Object)new ChunkCacheKey(INDEXNAME, fileName, ++chunkIndex, 64));
            }
            byte predictableByte = bytesGenerator.nextByte();
            if (i < pointers[indexPointer]) {
                Assert.assertEquals((byte)predictableByte, (byte)buffer[i % 64]);
            } else if (pointers[indexPointer] <= i && i < pointers[indexPointer] + someTextAsBytes.length) {
                Assert.assertEquals((byte)someTextAsBytes[i - pointers[indexPointer]], (byte)buffer[i % 64]);
            }
            if (i != pointers[indexPointer] + someTextAsBytes.length) continue;
            ++indexPointer;
        }
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    @Test
    public void testReadWholeFile() throws IOException {
        int BUFFER_SIZE = 64;
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 64);
        this.verifyOnBuffer("SingleChunk.txt", 61, 64, cache, dir, 15);
        int VERY_BIG_FILE_SIZE = 10000;
        this.verifyOnBuffer("MultipleChunks.txt", 10000, 64, cache, dir, 33);
        int LAST_CHUNK_COMPLETELY_FILLED_FILE_SIZE = 256;
        this.verifyOnBuffer("LastChunkFilled.txt", 256, 64, cache, dir, 11);
        this.assertHasNChunks(4, cache, INDEXNAME, "LastChunkFilled.txt.bak", 64);
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
        int LAST_CHUNK_WITH_LONELY_BYTE_FILE_SIZE = 257;
        this.verifyOnBuffer("LonelyByteInLastChunk.txt", 257, 64, cache, dir, 12);
        this.assertHasNChunks(5, cache, INDEXNAME, "LonelyByteInLastChunk.txt.bak", 64);
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    private void verifyOnBuffer(String fileName, int fileSize, int bufferSize, Cache cache, InfinispanDirectory dir, int readBuffer) throws IOException {
        this.createFileWithRepeatableContent(dir, fileName, fileSize);
        this.assertReadByteWorkingCorrectly(dir, fileName, fileSize);
        this.assertReadBytesWorkingCorrectly(dir, fileName, fileSize, readBuffer);
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
        String newFileName = fileName + ".bak";
        dir.renameFile(fileName, newFileName);
        this.assertReadByteWorkingCorrectly(dir, newFileName, fileSize);
        this.assertReadBytesWorkingCorrectly(dir, newFileName, fileSize, readBuffer);
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
        assert (dir.fileExists(newFileName));
        assert (!dir.fileExists(fileName));
    }

    @Test
    public void testReadRandomSampleFile() throws IOException {
        int BUFFER_SIZE = 64;
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 64);
        int FILE_SIZE = 1000;
        this.createFileWithRepeatableContent(dir, "RandomSampleFile.txt", 1000);
        IndexInput indexInput = dir.openInput("RandomSampleFile.txt");
        assert (indexInput.length() == 1000L);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        Random r = new Random();
        long seekPoint = 0L;
        for (int i = 0; i < 1000; ++i) {
            if (seekPoint == (long)i) {
                byte expectedByte = bytesGenerator.nextByte();
                byte actualByte = indexInput.readByte();
                assert (expectedByte == actualByte);
                seekPoint = indexInput.getFilePointer() + (long)r.nextInt(10);
                indexInput.seek(seekPoint);
                continue;
            }
            bytesGenerator.nextByte();
        }
        indexInput.close();
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    private void assertReadBytesWorkingCorrectly(InfinispanDirectory dir, String fileName, int contentFileSizeExpected, int arrayLengthToRead) throws IOException {
        int nextBytesToRead;
        IndexInput indexInput = dir.openInput(fileName);
        assert (indexInput.length() == (long)contentFileSizeExpected);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        byte[] readBytes = new byte[arrayLengthToRead];
        byte[] expectedBytes = new byte[arrayLengthToRead];
        for (long toRead = (long)contentFileSizeExpected; toRead > 0L; toRead -= (long)nextBytesToRead) {
            if (toRead < (long)arrayLengthToRead) {
                readBytes = new byte[(int)toRead];
                expectedBytes = new byte[(int)toRead];
            }
            nextBytesToRead = (int)Math.min(toRead, (long)arrayLengthToRead);
            bytesGenerator.nextBytes(expectedBytes);
            indexInput.readBytes(readBytes, 0, nextBytesToRead);
            assert (Arrays.equals(expectedBytes, readBytes));
        }
        indexInput.close();
    }

    private void assertReadByteWorkingCorrectly(InfinispanDirectory dir, String fileName, int contentFileSizeExpected) throws IOException {
        IndexInput indexInput = dir.openInput(fileName);
        assert (indexInput.length() == (long)contentFileSizeExpected);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        for (int i = 0; i < contentFileSizeExpected; ++i) {
            assert (bytesGenerator.nextByte() == indexInput.readByte());
        }
        indexInput.close();
    }

    private void assertHasNChunks(int expectedChunks, Cache cache, String index, String fileName, int bufferSize) {
        ChunkCacheKey key;
        int i;
        for (i = 0; i < expectedChunks; ++i) {
            key = new ChunkCacheKey(index, fileName, i, bufferSize);
            Assert.assertTrue((boolean)cache.containsKey((Object)key), (String)("should contain key " + key));
        }
        key = new ChunkCacheKey(index, fileName, i, bufferSize);
        Assert.assertFalse((boolean)cache.containsKey((Object)key), (String)("should NOT contain key " + key));
    }

    private void createFileWithRepeatableContent(InfinispanDirectory dir, String fileName, int contentFileSize) throws IOException {
        IndexOutput indexOutput = dir.createOutput(fileName);
        RepeatableLongByteSequence bytesGenerator = new RepeatableLongByteSequence();
        for (int i = 0; i < contentFileSize; ++i) {
            indexOutput.writeByte(bytesGenerator.nextByte());
        }
        indexOutput.close();
    }

    @Test(enabled=false)
    public void testReadChunks() throws Exception {
        int bytesRead;
        long toRead;
        int bytesRead2;
        int BUFFER_SIZE = 64;
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 64);
        FileMetadata file1 = new FileMetadata(5);
        FileCacheKey key1 = new FileCacheKey(INDEXNAME, "Hello.txt");
        cache.put((Object)key1, (Object)file1);
        FileMetadata file2 = new FileMetadata(5);
        FileCacheKey key2 = new FileCacheKey(INDEXNAME, "World.txt");
        cache.put((Object)key2, (Object)file2);
        String helloText = "Hello world.  This is some text.";
        cache.put((Object)new ChunkCacheKey(INDEXNAME, "Hello.txt", 0, 64), (Object)helloText.getBytes());
        String worldText = "This String should contain more than sixty four characters but less than one hundred and twenty eight.";
        assert (worldText.getBytes().length > 64);
        assert (worldText.getBytes().length < 128);
        byte[] buf = new byte[64];
        System.arraycopy(worldText.getBytes(), 0, buf, 0, 64);
        cache.put((Object)new ChunkCacheKey(INDEXNAME, "World.txt", 0, 64), (Object)buf);
        String part1 = new String(buf);
        buf = new byte[64];
        System.arraycopy(worldText.getBytes(), 64, buf, 0, worldText.length() - 64);
        cache.put((Object)new ChunkCacheKey(INDEXNAME, "World.txt", 1, 64), (Object)buf);
        String part2 = new String(buf);
        assert (worldText.equals(part1 + part2.trim()));
        file1.setSize((long)helloText.length());
        file2.setSize((long)worldText.length());
        HashSet<String> s = new HashSet<String>();
        s.add("Hello.txt");
        s.add("World.txt");
        HashSet<String> other = new HashSet<String>(Arrays.asList(dir.list()));
        assert (s.equals(other));
        IndexInput ii = dir.openInput("Hello.txt");
        assert (ii.length() == (long)helloText.length());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < ii.length()) {
            baos.write(ii.readByte());
            ++i;
        }
        assert (new String(baos.toByteArray()).equals(helloText));
        ii = dir.openInput("World.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        i = 0;
        while ((long)i < ii.length()) {
            baos.write(ii.readByte());
            ++i;
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        ii = dir.openInput("Hello.txt");
        assert (ii.length() == (long)helloText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead2) {
            buf = new byte[19];
            bytesRead2 = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead2);
            baos.write(buf, 0, bytesRead2);
        }
        assert (new String(baos.toByteArray()).equals(helloText));
        ii = dir.openInput("World.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead2) {
            buf = new byte[19];
            bytesRead2 = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead2);
            baos.write(buf, 0, bytesRead2);
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        dir.deleteFile("Hello.txt");
        assert (null == cache.get((Object)new FileCacheKey(INDEXNAME, "Hello.txt")));
        assert (null == cache.get((Object)new ChunkCacheKey(INDEXNAME, "Hello.txt", 0, 64)));
        Object ob1 = cache.get((Object)new FileCacheKey(INDEXNAME, "World.txt"));
        Object ob2 = cache.get((Object)new ChunkCacheKey(INDEXNAME, "World.txt", 0, 64));
        Object ob3 = cache.get((Object)new ChunkCacheKey(INDEXNAME, "World.txt", 1, 64));
        dir.renameFile("World.txt", "HelloWorld.txt");
        assert (null == cache.get((Object)new FileCacheKey(INDEXNAME, "Hello.txt")));
        assert (null == cache.get((Object)new ChunkCacheKey(INDEXNAME, "Hello.txt", 0, 64)));
        assert (null == cache.get((Object)new ChunkCacheKey(INDEXNAME, "Hello.txt", 1, 64)));
        assert (cache.get((Object)new FileCacheKey(INDEXNAME, "HelloWorld.txt")).equals(ob1));
        assert (cache.get((Object)new ChunkCacheKey(INDEXNAME, "HelloWorld.txt", 0, 64)).equals(ob2));
        assert (cache.get((Object)new ChunkCacheKey(INDEXNAME, "HelloWorld.txt", 1, 64)).equals(ob3));
        ii = dir.openInput("HelloWorld.txt");
        assert (ii.length() == (long)worldText.length());
        baos = new ByteArrayOutputStream();
        for (toRead = ii.length(); toRead > 0L; toRead -= (long)bytesRead) {
            buf = new byte[19];
            bytesRead = (int)Math.min(toRead, 19L);
            ii.readBytes(buf, 0, bytesRead);
            baos.write(buf, 0, bytesRead);
        }
        assert (new String(baos.toByteArray()).equals(worldText));
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    public void testWriteChunks() throws Exception {
        int BUFFER_SIZE = 64;
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 64);
        IndexOutput io = dir.createOutput("MyNewFile.txt");
        io.writeByte((byte)66);
        io.writeByte((byte)69);
        io.flush();
        io.close();
        assert (dir.fileExists("MyNewFile.txt"));
        assert (null != cache.get((Object)new ChunkCacheKey(INDEXNAME, "MyNewFile.txt", 0, 64)));
        byte[] buf = new byte[9];
        IndexInput ii = dir.openInput("MyNewFile.txt");
        ii.readBytes(buf, 0, (int)ii.length());
        ii.close();
        assert (new String(new byte[]{66, 69}).equals(new String(buf).trim()));
        String testText = "This is some rubbish again that will span more than one chunk - one hopes.  Who knows, maybe even three or four chunks.";
        io = dir.createOutput("MyNewFile.txt");
        io.seek(0L);
        io.writeBytes(testText.getBytes(), 0, testText.length());
        io.close();
        byte[] chunk1 = (byte[])cache.get((Object)new ChunkCacheKey(INDEXNAME, "MyNewFile.txt", 0, 64));
        byte[] chunk2 = (byte[])cache.get((Object)new ChunkCacheKey(INDEXNAME, "MyNewFile.txt", 1, 64));
        assert (null != chunk1);
        assert (null != chunk2);
        assert (testText.equals(new String(chunk1) + new String(chunk2).trim()));
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    @Test
    public void testWriteChunksDefaultChunks() throws Exception {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, INDEXNAME);
        String testText = "This is some rubbish";
        byte[] testTextAsBytes = "This is some rubbish".getBytes();
        IndexOutput io = dir.createOutput("MyNewFile.txt");
        io.writeByte((byte)1);
        io.writeByte((byte)2);
        io.writeByte((byte)3);
        io.writeBytes(testTextAsBytes, testTextAsBytes.length);
        io.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
        FileCacheKey fileCacheKey = new FileCacheKey(INDEXNAME, "MyNewFile.txt");
        assert (null != cache.get((Object)fileCacheKey));
        FileMetadata metadata = (FileMetadata)cache.get((Object)fileCacheKey);
        Assert.assertEquals((long)(testTextAsBytes.length + 3), (long)metadata.getSize());
        assert (null != cache.get((Object)new ChunkCacheKey(INDEXNAME, "MyNewFile.txt", 0, 16384)));
        IndexInput ii = dir.openInput("MyNewFile.txt");
        assert (ii.readByte() == 1);
        assert (ii.readByte() == 2);
        assert (ii.readByte() == 3);
        byte[] buf = new byte[testTextAsBytes.length];
        ii.readBytes(buf, 0, testTextAsBytes.length);
        ii.close();
        assert ("This is some rubbish".equals(new String(buf).trim()));
        dir.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, INDEXNAME);
    }

    @Test
    public void testChunkBordersOnInfinispan() throws IOException {
        Cache cache = this.cacheManager.getCache();
        cache.clear();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 13);
        this.testChunkBorders((Directory)dir, cache);
        cache.clear();
    }

    @Test
    public void testChunkBordersOnRAMDirectory() throws IOException {
        RAMDirectory dir = new RAMDirectory();
        this.testChunkBorders((Directory)dir, null);
    }

    private void testChunkBorders(Directory dir, Cache cache) throws IOException {
        this.testOn(dir, 0, 0, cache);
        this.testOn(dir, 0, 1, cache);
        this.testOn(dir, 1, 1, cache);
        this.testOn(dir, 1, 0, cache);
        this.testOn(dir, 13, 13, cache);
        this.testOn(dir, 12, 13, cache);
        this.testOn(dir, 13, 12, cache);
        this.testOn(dir, 12, 12, cache);
        this.testOn(dir, 13, 14, cache);
        this.testOn(dir, 14, 13, cache);
        this.testOn(dir, 14, 14, cache);
        this.testOn(dir, 39, 39, cache);
        this.testOn(dir, 38, 38, cache);
        this.testOn(dir, 38, 39, cache);
        this.testOn(dir, 39, 38, cache);
        this.testOn(dir, 40, 40, cache);
        this.testOn(dir, 40, 39, cache);
        this.testOn(dir, 39, 40, cache);
        this.testOn(dir, 600, 600, cache);
    }

    private void testOn(Directory dir, int writeSize, int readSize, Cache cache) throws IOException {
        block8: {
            if (cache != null) {
                cache.clear();
            }
            String filename = "chunkTest";
            IndexOutput indexOutput = dir.createOutput("chunkTest");
            byte[] toWrite = this.fillBytes(writeSize);
            indexOutput.writeBytes(toWrite, writeSize);
            indexOutput.close();
            if (cache != null) assert ((long)writeSize == DirectoryIntegrityCheck.deepCountFileSize(new FileCacheKey(INDEXNAME, "chunkTest"), cache));
            assert (indexOutput.length() == (long)writeSize);
            byte[] results = new byte[readSize];
            IndexInput openInput = dir.openInput("chunkTest");
            try {
                openInput.readBytes(results, 0, readSize);
                for (int i = 0; i < writeSize && i < readSize; ++i) {
                    assert (toWrite[i] == results[i]);
                }
                if (readSize > writeSize) assert (false) : "should have thrown an IOException for reading past EOF";
            }
            catch (IOException ioe) {
                if (readSize > writeSize || $assertionsDisabled) break block8;
                throw new AssertionError((Object)("should not have thrown an IOException" + ioe.getMessage()));
            }
        }
    }

    public void multipleFlushTest() throws IOException {
        String filename = "longFile.writtenInMultipleFlushes";
        int bufferSize = 300;
        Cache cache = this.cacheManager.getCache();
        cache.clear();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, cache, INDEXNAME, 13);
        byte[] manyBytes = this.fillBytes(300);
        IndexOutput indexOutput = dir.createOutput("longFile.writtenInMultipleFlushes");
        for (int i = 0; i < 10; ++i) {
            indexOutput.writeBytes(manyBytes, 300);
            indexOutput.flush();
        }
        indexOutput.close();
        IndexInput input = dir.openInput("longFile.writtenInMultipleFlushes");
        int finalSize = 3000;
        assert (input.length() == 3000L);
        byte[] resultingBuffer = new byte[3000];
        input.readBytes(resultingBuffer, 0, 3000);
        int index = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 300; ++j) {
                assert (resultingBuffer[index++] == manyBytes[j]);
            }
        }
    }

    private byte[] fillBytes(int size) {
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)i;
        }
        return b;
    }
}

