/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore;

import org.apache.lucene.store.Directory;
import org.infinispan.lucene.cachestore.DirectoryV3Adaptor;
import org.infinispan.lucene.cachestore.InternalDirectoryContract;
import org.infinispan.lucene.impl.LuceneVersionDetector;
import org.infinispan.lucene.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ContractAdaptorFactory {
    private static final Log log = (Log)LogFactory.getLog(ContractAdaptorFactory.class, Log.class);

    public static InternalDirectoryContract wrapNativeDirectory(Directory directory) {
        InternalDirectoryContract idc;
        if (LuceneVersionDetector.VERSION == 3) {
            return new DirectoryV3Adaptor(directory);
        }
        Class[] ctorType = new Class[]{Directory.class};
        try {
            idc = (InternalDirectoryContract)ContractAdaptorFactory.class.getClassLoader().loadClass("org.infinispan.lucene.cachestore.DirectoryV4Adaptor").getConstructor(ctorType).newInstance(directory);
        }
        catch (Exception e) {
            throw log.failedToCreateLucene4Directory(e);
        }
        return idc;
    }
}

