/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.impl.DirectoryImplementor;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.InfinispanIndexInputV3;
import org.infinispan.lucene.impl.SingleChunkIndexInput;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

class DirectoryLuceneV3
extends Directory
implements DirectoryExtensions {
    private final DirectoryImplementor impl;
    private final String indexName;

    DirectoryLuceneV3(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker) {
        this.impl = new DirectoryImplementor(metadataCache, chunksCache, indexName, chunkSize, readLocker);
        this.indexName = indexName;
        this.lockFactory = lf;
        this.lockFactory.setLockPrefix(this.getLockID());
    }

    public String[] list() {
        this.ensureOpen();
        return this.impl.list();
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        return this.impl.fileExists(name);
    }

    public long fileModified(String name) {
        this.ensureOpen();
        return this.impl.fileModified(name);
    }

    public void touchFile(String fileName) {
        this.ensureOpen();
        this.impl.touchFile(fileName);
    }

    public void deleteFile(String name) {
        this.ensureOpen();
        this.impl.deleteFile(name);
    }

    @Override
    public void renameFile(String from, String to) {
        this.impl.renameFile(from, to);
    }

    public long fileLength(String name) {
        this.ensureOpen();
        return this.impl.fileLength(name);
    }

    public IndexOutput createOutput(String name) {
        return this.impl.createOutput(name);
    }

    public IndexInput openInput(String name) throws IOException {
        IndexInputContext indexInputContext = this.impl.openInput(name);
        if (indexInputContext.readLocks == null) {
            return new SingleChunkIndexInput(indexInputContext);
        }
        return new InfinispanIndexInputV3(indexInputContext);
    }

    public void close() {
        this.isOpen = false;
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + "'}";
    }

    public String[] listAll() {
        return this.list();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }
}

