/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.cachestore.ContractAdaptorFactory;
import org.infinispan.lucene.cachestore.DirectoryLoaderAdaptor;
import org.infinispan.lucene.cachestore.InternalDirectoryContract;
import org.infinispan.lucene.cachestore.configuration.LuceneStoreConfiguration;
import org.infinispan.lucene.logging.Log;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.MarshalledEntryImpl;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshalledEntry;
import org.infinispan.util.logging.LogFactory;

public class LuceneCacheLoader
implements AdvancedCacheLoader {
    private static final Log log = (Log)LogFactory.getLog(LuceneCacheLoader.class, Log.class);
    private final ConcurrentHashMap<String, DirectoryLoaderAdaptor> openDirectories = new ConcurrentHashMap();
    private String fileRoot;
    private File rootDirectory;
    private int autoChunkSize;
    private LuceneStoreConfiguration configuration;
    private InitializationContext ctx;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (LuceneStoreConfiguration)ctx.getConfiguration();
        this.fileRoot = this.configuration.location();
        this.autoChunkSize = this.configuration.autoChunkSize();
    }

    public MarshalledEntry load(Object key) throws CacheLoaderException {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            Object value = directoryAdaptor.load(indexKey);
            if (value != null) {
                return new MarshalledEntryImpl(key, value, null, this.ctx.getMarshaller());
            }
            return null;
        }
        log.cacheLoaderIgnoringKey(key);
        return null;
    }

    public boolean contains(Object key) throws CacheLoaderException {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            return directoryAdaptor.containsKey(indexKey);
        }
        log.cacheLoaderIgnoringKey(key);
        return false;
    }

    public void process(final AdvancedCacheLoader.KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        this.scanForUnknownDirectories();
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        final TaskContextImpl taskContext = new TaskContextImpl();
        int count = 0;
        for (final DirectoryLoaderAdaptor dir : this.openDirectories.values()) {
            ecs.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    HashSet<MarshalledEntry> allInternalEntries = new HashSet<MarshalledEntry>();
                    dir.loadAllEntries(allInternalEntries, Integer.MAX_VALUE, LuceneCacheLoader.this.ctx.getMarshaller());
                    for (MarshalledEntry me : allInternalEntries) {
                        if (taskContext.isStopped()) break;
                        if (filter != null && !filter.shouldLoadKey(me.getKey())) continue;
                        task.processEntry(me, (AdvancedCacheLoader.TaskContext)taskContext);
                    }
                    return null;
                }
            });
            ++count;
        }
        PersistenceUtil.waitForAllTasksToComplete(ecs, (int)count);
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    private void scanForUnknownDirectories() {
        File[] filesInRoot;
        for (File maybeDirectory : filesInRoot = this.rootDirectory.listFiles()) {
            if (!maybeDirectory.isDirectory()) continue;
            String name = maybeDirectory.getName();
            try {
                this.getDirectory(name);
            }
            catch (CacheLoaderException e) {
                log.couldNotWalkDirectory(name, e);
            }
        }
    }

    public void start() throws CacheLoaderException {
        this.rootDirectory = new File(this.fileRoot);
        if (this.rootDirectory.exists()) {
            if (!this.rootDirectory.isDirectory() || !this.rootDirectory.canRead()) {
                throw log.rootDirectoryIsNotADirectory(this.fileRoot);
            }
        } else {
            boolean mkdirsSuccess = this.rootDirectory.mkdirs();
            if (!mkdirsSuccess) {
                throw log.unableToCreateDirectory(this.fileRoot);
            }
        }
    }

    public void stop() throws CacheLoaderException {
        for (Map.Entry<String, DirectoryLoaderAdaptor> entry : this.openDirectories.entrySet()) {
            DirectoryLoaderAdaptor directory = entry.getValue();
            directory.close();
        }
    }

    private DirectoryLoaderAdaptor getDirectory(IndexScopedKey indexKey) throws CacheLoaderException {
        String indexName = indexKey.getIndexName();
        return this.getDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryLoaderAdaptor getDirectory(String indexName) throws CacheLoaderException {
        DirectoryLoaderAdaptor adapter = this.openDirectories.get(indexName);
        if (adapter == null) {
            ConcurrentHashMap<String, DirectoryLoaderAdaptor> concurrentHashMap = this.openDirectories;
            synchronized (concurrentHashMap) {
                adapter = this.openDirectories.get(indexName);
                if (adapter == null) {
                    File path = new File(this.rootDirectory, indexName);
                    FSDirectory directory = this.openLuceneDirectory(path);
                    InternalDirectoryContract wrapped = ContractAdaptorFactory.wrapNativeDirectory((Directory)directory);
                    adapter = new DirectoryLoaderAdaptor(wrapped, indexName, this.autoChunkSize);
                    this.openDirectories.put(indexName, adapter);
                }
            }
        }
        return adapter;
    }

    private FSDirectory openLuceneDirectory(File path) throws CacheLoaderException {
        try {
            return FSDirectory.open((File)path);
        }
        catch (IOException e) {
            throw log.exceptionInCacheLoader(e);
        }
    }
}

