/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.cacheloader.DirectoryLoaderAdaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cachestore.LargeIndexesTest")
public class LargeIndexesTest {
    private static final String INDEX_NAME = "myIndex";
    private static final String FILE_NAME = "largeFile";
    private static final long TEST_SIZE = 0x80000009L;
    private static final int AUTO_BUFFER = 16;

    private Directory createMockDirectory() throws IOException {
        Directory mockDirectory = (Directory)Mockito.mock(Directory.class);
        Mockito.when((Object)mockDirectory.openInput(FILE_NAME, IOContext.READ)).thenAnswer((Answer)new Answer<IndexInputMock>(){

            public IndexInputMock answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new IndexInputMock(LargeIndexesTest.FILE_NAME);
            }
        });
        Mockito.when((Object)mockDirectory.fileLength(FILE_NAME)).thenReturn((Object)0x80000009L);
        ((Directory)Mockito.verify((Object)mockDirectory, (VerificationMode)Mockito.never())).listAll();
        ((Directory)Mockito.verify((Object)mockDirectory, (VerificationMode)Mockito.never())).fileExists(FILE_NAME);
        return mockDirectory;
    }

    public void testAutoChunkingOnLargeFiles() throws IOException {
        Directory mockDirectory = this.createMockDirectory();
        FileCacheKey k = new FileCacheKey(INDEX_NAME, FILE_NAME);
        DirectoryLoaderAdaptor adaptor = new DirectoryLoaderAdaptor(mockDirectory, INDEX_NAME, 16);
        Object loaded = adaptor.load((IndexScopedKey)k);
        AssertJUnit.assertTrue((boolean)(loaded instanceof FileMetadata));
        FileMetadata metadata = (FileMetadata)loaded;
        AssertJUnit.assertEquals((long)0x80000009L, (long)metadata.getSize());
        AssertJUnit.assertEquals((int)16, (int)metadata.getBufferSize());
    }

    public void testSmallChunkLoading() throws IOException {
        Directory mockDirectory = this.createMockDirectory();
        DirectoryLoaderAdaptor adaptor = new DirectoryLoaderAdaptor(mockDirectory, INDEX_NAME, 16);
        Object loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 0, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((int)16, (int)((byte[])loaded).length);
        loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 5, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((int)16, (int)((byte[])loaded).length);
        int lastChunk = 0x8000000;
        long lastChunkSize = 9L;
        AssertJUnit.assertEquals((long)9L, (long)9L);
        loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 0x8000000, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((long)9L, (long)((byte[])loaded).length);
    }

    private static class IndexInputMock
    extends IndexInput {
        private boolean closed = false;
        private long position = 0L;

        protected IndexInputMock(String resourceDescription) {
            super(resourceDescription);
        }

        public void close() throws IOException {
            AssertJUnit.assertFalse((boolean)this.closed);
            this.closed = true;
        }

        public long getFilePointer() {
            AssertJUnit.fail((String)"should not be invoked");
            return 0L;
        }

        public void seek(long pos) throws IOException {
            this.position = pos;
        }

        public long length() {
            return 0x80000009L;
        }

        public byte readByte() throws IOException {
            return 0;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long remainingFileSize = 0x80000009L - this.position;
            long expectedReadSize = Math.min(remainingFileSize, 16L);
            AssertJUnit.assertEquals((long)expectedReadSize, (long)b.length);
            AssertJUnit.assertEquals((int)0, (int)offset);
            AssertJUnit.assertEquals((long)expectedReadSize, (long)len);
        }
    }
}

