/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.profiling.LuceneReaderThread;
import org.infinispan.lucene.profiling.LuceneWriterThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.PerformanceCompareStressTest", sequential=true)
public class PerformanceCompareStressTest {
    private static final int NUM_NODES = 4;
    private static final String CONFIGURATION = "perf-udp.xml";
    private static final int DICTIONARY_SIZE = 800000;
    private static final int READER_THREADS = 5;
    private static final int WRITER_THREADS = 1;
    private static final int CHUNK_SIZE = 524288;
    private static final String indexName = "tempIndexName";
    private static final long DEFAULT_DURATION_MS = 120000L;
    private long durationMs = 120000L;
    private final Map<Integer, EmbeddedCacheManager> cacheManagers = new HashMap<Integer, EmbeddedCacheManager>();
    private Properties results = null;
    private String currentMethod = null;

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        this.stressTestDirectoryInternal((Directory)dir, (Directory)dir, "RAMDirectory");
    }

    @Test
    public void profileTestFSDirectory() throws InterruptedException, IOException {
        File indexDir = new File(TestingUtil.tmpDirectory(this.getClass()), indexName);
        boolean directoriesCreated = indexDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for FSDirectory test";
        FSDirectory dir = FSDirectory.open((File)indexDir);
        this.stressTestDirectoryInternal((Directory)dir, (Directory)dir, "FSDirectory");
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelayZero() throws Exception {
        this.setNetworkDelay(0);
        Directory dir1 = this.buildDirectoryFromNode(1);
        Directory dir2 = this.buildDirectoryFromNode(3);
        this.stressTestDirectoryInternal(dir1, dir2, "InfinispanClustered-delayedIO:0");
        this.verifyDirectoryState();
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelay1() throws Exception {
        this.setNetworkDelay(1);
        Directory dir1 = this.buildDirectoryFromNode(1);
        Directory dir2 = this.buildDirectoryFromNode(3);
        this.stressTestDirectoryInternal(dir1, dir2, "InfinispanClustered-delayedIO:1");
        this.verifyDirectoryState();
        this.setNetworkDelay(0);
    }

    @Test
    public void profileTestInfinispanDirectoryWithHighNetworkDelay4() throws Exception {
        this.setNetworkDelay(4);
        Directory dir1 = this.buildDirectoryFromNode(1);
        Directory dir2 = this.buildDirectoryFromNode(3);
        this.stressTestDirectoryInternal(dir1, dir2, "InfinispanClustered-delayedIO:4");
        this.verifyDirectoryState();
        this.setNetworkDelay(0);
    }

    @Test
    public void profileTestInfinispanDirectoryWithHighNetworkDelay20() throws Exception {
        this.setNetworkDelay(20);
        Directory dir1 = this.buildDirectoryFromNode(1);
        Directory dir2 = this.buildDirectoryFromNode(3);
        this.stressTestDirectoryInternal(dir1, dir2, "InfinispanClustered-delayedIO:20");
        this.verifyDirectoryState();
        this.setNetworkDelay(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheContainer cacheContainer = CacheTestSupport.createLocalCacheManager();
        try {
            Cache cache = cacheContainer.getCache();
            Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)indexName).chunkSize(524288).create();
            this.stressTestDirectoryInternal(dir, dir, "InfinispanLocal");
            this.verifyDirectoryState();
        }
        finally {
            cacheContainer.stop();
        }
    }

    @Test(enabled=false)
    public static void stressTestDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        PerformanceCompareStressTest.stressTestDirectory(dir, dir, testLabel, 120000L, null, null);
    }

    private void stressTestDirectoryInternal(Directory dirWriter, Directory dirReaders, String testLabel) throws InterruptedException, IOException {
        PerformanceCompareStressTest.stressTestDirectory(dirWriter, dirReaders, testLabel, this.durationMs, this.results, this.currentMethod);
    }

    private void setNetworkDelay(int delay) throws Exception {
        for (int i = 0; i < 4; ++i) {
            EmbeddedCacheManager cm = this.cacheManagers.get(i);
            TestingUtil.setDelayForCache((Cache)cm.getCache(), (int)delay, (int)delay);
        }
        System.out.println("Simulating network packet delay of: " + delay);
    }

    private Directory buildDirectoryFromNode(int node) {
        EmbeddedCacheManager cm = this.cacheManagers.get(node);
        return DirectoryBuilder.newDirectoryInstance((Cache)cm.getCache("index_metadata"), (Cache)cm.getCache("index_data"), (Cache)cm.getCache("index_locks"), (String)indexName).chunkSize(524288).create();
    }

    @Test(enabled=false)
    private static void stressTestDirectory(Directory dirWriter, Directory dirReaders, String testLabel, long durationMs, Properties results, String currentMethod) throws InterruptedException, IOException {
        int i;
        SharedState state = new SharedState(800000);
        CacheTestSupport.initializeDirectory(dirWriter);
        ExecutorService e = Executors.newFixedThreadPool(6);
        for (i = 0; i < 5; ++i) {
            e.execute(new LuceneReaderThread(dirReaders, state));
        }
        for (i = 0; i < 1; ++i) {
            e.execute(new LuceneWriterThread(dirWriter, state));
        }
        e.shutdown();
        System.out.println("Started test: " + testLabel);
        state.startWaitingThreads();
        Thread.sleep(durationMs);
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        state.quit();
        boolean terminatedCorrectly = e.awaitTermination(20L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)terminatedCorrectly);
        System.out.println("Test " + testLabel + " run in " + durationMs + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
        if (results != null) {
            results.setProperty(currentMethod + ".label", testLabel);
            results.setProperty(currentMethod + ".searches", Long.toString(searchesCount));
            results.setProperty(currentMethod + ".writes", Long.toString(writerTaskCount));
        }
    }

    @BeforeMethod
    public void beforeTest() throws IOException {
        for (int i = 0; i < 4; ++i) {
            DefaultCacheManager node = new DefaultCacheManager(CONFIGURATION);
            node.start();
            node.getCache("index_metadata").start();
            node.getCache("index_data").start();
            node.getCache("index_locks").start();
            this.cacheManagers.put(i, (EmbeddedCacheManager)node);
        }
    }

    @AfterMethod
    public void afterTest() {
        for (EmbeddedCacheManager node : this.cacheManagers.values()) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{node});
        }
        TestingUtil.recursiveFileRemove((String)indexName);
    }

    private void verifyDirectoryState() {
        for (EmbeddedCacheManager embeddedCacheManager : this.cacheManagers.values()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] testMethods = System.getProperty("lucene.profiling.tests", "profileTestRAMDirectory,profileTestFSDirectory,profileInfinispanLocalDirectory,profileTestInfinispanDirectoryWithNetworkDelayZero").split(",");
        PerformanceCompareStressTest test = new PerformanceCompareStressTest();
        test.durationMs = new Long(System.getProperty("lucene.profiling.duration", String.valueOf(120000L)));
        String outputFile = System.getProperty("lucene.profiling.output");
        test.results = outputFile == null ? null : new Properties();
        for (String testMethod : testMethods) {
            try {
                test.currentMethod = testMethod;
                Method m = PerformanceCompareStressTest.class.getMethod(testMethod, new Class[0]);
                test.beforeTest();
                try {
                    m.invoke((Object)test, new Object[0]);
                }
                finally {
                    test.afterTest();
                }
            }
            catch (NoSuchMethodException e) {
                System.out.println("Couldn't find method " + testMethod);
                System.exit(1);
            }
        }
        if (test.results != null && !test.results.isEmpty()) {
            System.out.println("Writing results to " + outputFile + " ...");
            TestingUtil.outputPropertiesToXML((String)outputFile, (Properties)test.results);
        }
    }
}

