/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.InboundInvocationHandlerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.jgroups.blocks.Response;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DeltaReplicationTest")
public class DeltaReplicationTest
extends MultipleCacheManagersTest {
    private static final String INDEX_NAME = "index";

    @Test
    public void testDeltasAreSent() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)cache0, (Cache)cache0, (Cache)cache0, (String)INDEX_NAME).create();
        InboundInvocationHandlerDecorator handler = new InboundInvocationHandlerDecorator();
        this.replaceOn(cache0, (InboundInvocationHandler)handler);
        this.replaceOn(cache1, (InboundInvocationHandler)handler);
        this.writeSingleDocument(dir);
        this.assertFileListMatch(cache0, cache1, INDEX_NAME);
        this.assertOnlyDeltasWereSent(handler, FileListCacheKey.class);
    }

    private void assertOnlyDeltasWereSent(InboundInvocationHandlerDecorator handler, Class<?> clazz) {
        Set<AbstractDataWriteCommand> writeCommands = handler.writeCommands;
        for (AbstractDataWriteCommand command : writeCommands) {
            PutKeyValueCommand putKeyValueCommand;
            if (!(command instanceof PutKeyValueCommand) || !(putKeyValueCommand = (PutKeyValueCommand)command).getKey().getClass().equals(clazz)) continue;
            Object value = putKeyValueCommand.getValue();
            AssertJUnit.assertTrue((boolean)(value instanceof Delta));
        }
    }

    private void assertFileListMatch(Cache cache, Cache another, String index) {
        AssertJUnit.assertEquals((Object)this.extract(cache, index), (Object)this.extract(another, index));
    }

    private FileListCacheValue extract(Cache cache, String index) {
        DataContainer dataContainer = (DataContainer)TestingUtil.extractComponent((Cache)cache, DataContainer.class);
        InternalCacheEntry ice = dataContainer.get((Object)new FileListCacheKey(index));
        return (FileListCacheValue)ice.getValue();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = DeltaReplicationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
    }

    private void replaceOn(Cache cache, InboundInvocationHandler replacement) {
        TestingUtil.replaceComponent((CacheContainer)cache.getCacheManager(), InboundInvocationHandler.class, (Object)replacement, (boolean)true);
        JGroupsTransport t = (JGroupsTransport)TestingUtil.extractComponent((Cache)cache, Transport.class);
        CommandAwareRpcDispatcher card = t.getCommandAwareRpcDispatcher();
        TestingUtil.replaceField((Object)replacement, (String)"inboundInvocationHandler", (Object)card, CommandAwareRpcDispatcher.class);
    }

    private void writeSingleDocument(Directory dir) throws IOException {
        IndexWriter indexWriter = LuceneSettings.openWriter(dir, 10);
        Document document = new Document();
        document.add((IndexableField)new StringField("field", "value", Field.Store.YES));
        indexWriter.addDocument((Iterable)document);
        indexWriter.close();
    }

    class InboundInvocationHandlerDecorator
    extends InboundInvocationHandlerImpl {
        final Set<AbstractDataWriteCommand> writeCommands = new ConcurrentHashSet();

        InboundInvocationHandlerDecorator() {
        }

        public void handle(CacheRpcCommand cmd, Address origin, Response response, boolean preserveOrder) throws Throwable {
            SingleRpcCommand singleRpcCommand;
            ReplicableCommand command;
            if (cmd instanceof SingleRpcCommand && (command = (singleRpcCommand = (SingleRpcCommand)cmd).getCommand()) instanceof AbstractDataWriteCommand) {
                this.writeCommands.add((AbstractDataWriteCommand)command);
            }
            super.handle(cmd, origin, response, preserveOrder);
        }
    }
}

