/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLockerTest;
import org.infinispan.lucene.readlocks.NoopSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.NoopSegmentReadLockerTest")
public class NoopSegmentReadLockerTest
extends DistributedSegmentReadLockerTest {
    @Override
    Directory createDirectory(Cache cache) {
        return DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").chunkSize(6).overrideSegmentReadLocker((SegmentReadLocker)new NoopSegmentReadLocker()).create();
    }

    @Override
    @Test
    public void testIndexWritingAndFinding() throws IOException, InterruptedException {
        this.verifyBoth(this.cache0, this.cache1);
        IndexOutput indexOutput = this.dirA.createOutput("readme.txt", IOContext.DEFAULT);
        indexOutput.writeString("no need to write, nobody ever will read this");
        indexOutput.flush();
        indexOutput.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, true);
        IndexInput firstOpenOnB = this.dirB.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, true);
        this.dirA.deleteFile("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput cloneOfFirstOpenOnB = firstOpenOnB.clone();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        cloneOfFirstOpenOnB.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput firstOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput secondOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        firstOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        secondOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        firstOpenOnB.close();
        this.assertFileAfterDeletion(this.cache0);
        this.assertFileAfterDeletion(this.cache1);
        this.dirA.close();
        this.dirB.close();
        this.verifyDirectoryStructure(this.cache0);
        this.verifyDirectoryStructure(this.cache1);
    }

    private void assertFileAfterDeletion(Cache cache) {
        FileListCacheValue fileList = (FileListCacheValue)cache.get((Object)new FileListCacheKey("indexName"));
        AssertJUnit.assertNotNull((Object)fileList);
        AssertJUnit.assertFalse((boolean)fileList.contains("readme.txt"));
        FileMetadata metadata = (FileMetadata)cache.get((Object)new FileCacheKey("indexName", "readme.txt"));
        AssertJUnit.assertNotNull((Object)metadata);
        long totalFileSize = metadata.getSize();
        int chunkNumbers = (int)(totalFileSize / 6L);
        for (int i = 0; i < chunkNumbers; ++i) {
            AssertJUnit.assertNotNull((Object)cache.get((Object)new ChunkCacheKey("indexName", "readme.txt", i, 6)));
        }
        boolean fileNameExistsInCache = false;
        for (Object key : cache.keySet()) {
            FileCacheKey keyObj;
            if (!(key instanceof FileCacheKey) || !(keyObj = (FileCacheKey)key).getFileName().contains("readme.txt")) continue;
            fileNameExistsInCache = true;
        }
        AssertJUnit.assertTrue((boolean)fileNameExistsInCache);
    }

    private void verifyDirectoryStructure(Cache cache) {
        FileListCacheValue fileList = (FileListCacheValue)cache.get((Object)new FileListCacheKey("indexName"));
        AssertJUnit.assertNotNull((Object)fileList);
        int fileListCacheKeyInstances = 0;
        for (Object key : cache.keySet()) {
            if (key instanceof ChunkCacheKey) {
                ChunkCacheKey existingChunkKey = (ChunkCacheKey)key;
                AssertJUnit.assertEquals((String)existingChunkKey.getIndexName(), (String)"indexName");
                Object value = cache.get((Object)existingChunkKey);
                AssertJUnit.assertNotNull((Object)value);
                AssertJUnit.assertTrue((boolean)(value instanceof byte[]));
                byte[] buffer = (byte[])cache.get((Object)existingChunkKey);
                AssertJUnit.assertTrue((buffer.length != 0 ? 1 : 0) != 0);
                continue;
            }
            if (key instanceof FileCacheKey) {
                FileCacheKey fileCacheKey = (FileCacheKey)key;
                AssertJUnit.assertEquals((String)fileCacheKey.getIndexName(), (String)"indexName");
                String filename = fileCacheKey.getFileName();
                Object value = cache.get((Object)fileCacheKey);
                AssertJUnit.assertNotNull((Object)value);
                AssertJUnit.assertTrue((boolean)(value instanceof FileMetadata));
                FileMetadata metadata = (FileMetadata)value;
                long totalFileSize = metadata.getSize();
                long actualFileSize = DirectoryIntegrityCheck.deepCountFileSize(fileCacheKey, cache);
                AssertJUnit.assertEquals((long)actualFileSize, (long)totalFileSize);
                if (filename.contains("readme.txt")) {
                    AssertJUnit.assertFalse((String)(fileCacheKey + " should not have existed"), (boolean)fileList.contains(filename));
                    continue;
                }
                AssertJUnit.assertTrue((String)(fileCacheKey + " should not have existed"), (boolean)fileList.contains(filename));
                continue;
            }
            if (!(key instanceof FileListCacheKey)) continue;
            AssertJUnit.assertEquals((int)1, (int)(++fileListCacheKeyInstances));
        }
    }
}

