/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Version;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.DirectoryLuceneV4;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DirectoryImplementerTests")
public class DirectoryImplementerTests
extends SingleCacheManagerTest {
    private static final String INDEX_NAME = "index-A";
    private static final int BUFFER_SIZE = 1024;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(0).create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailureOfOverrideWriteLocker() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(null).create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverrideWriteLocker() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(new LockFactory(){

                public Lock makeLock(String lockName) {
                    return null;
                }

                public void clearLock(String lockName) throws IOException {
                }
            }).create();
            AssertJUnit.assertEquals((int)0, (int)dir.listAll().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetIndexNameAndToString() throws IOException {
        Cache cache = this.cacheManager.getCache();
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(1024).create();
            AssertJUnit.assertEquals((String)INDEX_NAME, (String)((DirectoryLuceneV4)dir).getIndexName());
            AssertJUnit.assertEquals((String)"InfinispanDirectory{indexName='index-A'}", (String)dir.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigureAsyncDeletes() throws Exception {
        Cache cache = this.cacheManager.getCache();
        Directory dir = null;
        Version version = Version.LUCENE_4_10_1;
        IndexWriterConfig iwc = new IndexWriterConfig(version, (Analyzer)new StandardAnalyzer());
        iwc.setMaxBufferedDocs(2);
        IndexWriter indexWriter = null;
        Document document = new Document();
        document.add((IndexableField)new TextField("field", "whatever", Field.Store.YES));
        TrackingThreadPoolExecutor executorService = new TrackingThreadPoolExecutor();
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(1024).deleteOperationsExecutor((Executor)executorService).create();
            indexWriter = new IndexWriter(dir, iwc);
            indexWriter.addDocument((Iterable)document);
            indexWriter.commit();
            indexWriter.addDocument((Iterable)document);
            indexWriter.commit();
            executorService.shutdown();
            AssertJUnit.assertTrue((boolean)executorService.isSegmentDeleted("0"));
            AssertJUnit.assertTrue((boolean)executorService.isSegmentDeleted("1"));
        }
        finally {
            if (indexWriter != null) {
                indexWriter.close();
            }
            if (dir != null) {
                dir.close();
            }
        }
    }

    class TrackingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Set<String> deletedSegments;

        TrackingThreadPoolExecutor() {
            super(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
            this.deletedSegments = new ConcurrentHashSet();
        }

        private String extractSegmentName(String fileName) {
            if (!fileName.startsWith("_")) {
                return null;
            }
            return fileName.substring(1, fileName.indexOf(46));
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            DirectoryLuceneV4.DeleteTask task = (DirectoryLuceneV4.DeleteTask)r;
            String name = task.getFileName();
            String segment = this.extractSegmentName(name);
            if (segment != null) {
                this.deletedSegments.add(segment);
            }
        }

        public boolean isSegmentDeleted(String segmentName) {
            return this.deletedSegments.contains(segmentName);
        }
    }
}

