/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.cacheloader.IndexCacheLoaderTest;
import org.infinispan.lucene.cacheloader.LuceneCacheLoader;
import org.infinispan.lucene.cacheloader.TestHelper;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cacheloader.LuceneCacheLoaderTest")
public class LuceneCacheLoaderTest
extends IndexCacheLoaderTest {
    private String indexName = "index-A";
    private int elementCount = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(expectedExceptions={CacheException.class})
    public void testLuceneCacheLoaderWithWrongDir() throws IOException {
        File file = null;
        try {
            file = new File(new File(this.parentDir).getAbsoluteFile(), "test.txt");
            boolean created = file.createNewFile();
            file.deleteOnExit();
            assert (created);
            final EmbeddedCacheManager cacheManager = this.initializeInfinispan(file);
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    Directory directory = null;
                    try {
                        Cache cache = cacheManager.getCache();
                        directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                    }
                    finally {
                        if (directory != null) {
                            try {
                                directory.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            if (file == null) return;
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            TestingUtil.recursiveFileRemove(file);
            throw throwable;
        }
        TestingUtil.recursiveFileRemove((File)file);
    }

    public void testLuceneCacheLoaderWithNonReadableDir() throws IOException {
        boolean isReadOff = this.rootDir.setReadable(false);
        if (isReadOff) {
            final EmbeddedCacheManager cacheManager = this.initializeInfinispan(this.rootDir);
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    try {
                        Cache cache = cacheManager.getCache();
                        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                    }
                    catch (Exception ex) {
                        assert (ex instanceof CacheException);
                    }
                    finally {
                        LuceneCacheLoaderTest.this.rootDir.setReadable(true);
                    }
                }
            });
        } else {
            System.out.println("The test is executed only if it is possible to make the directory non-readable. I.e. the tests are run not under the root.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainsKeyWithNoExistentRootDir() {
        final File rootDir = new File(new File(this.parentDir).getAbsoluteFile(), this.getIndexPathName() + "___");
        final EmbeddedCacheManager cacheManager = this.initializeInfinispan(rootDir);
        try {
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                public void call() {
                    Cache cache = cacheManager.getCache();
                    Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                    try {
                        TestHelper.createIndex(rootDir, LuceneCacheLoaderTest.this.indexName, LuceneCacheLoaderTest.this.elementCount, true);
                        TestHelper.verifyOnDirectory(directory, LuceneCacheLoaderTest.this.elementCount, true);
                        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(rootDir, LuceneCacheLoaderTest.this.indexName);
                        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)cacheManager.getCache());
                        for (String fileName : fileNamesFromIndexDir) {
                            FileCacheKey key = new FileCacheKey(LuceneCacheLoaderTest.this.indexName, fileName);
                            assert (cacheLoader.contains((Object)key));
                            assert (!cacheLoader.contains((Object)fileName));
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        finally {
            TestingUtil.recursiveFileRemove((File)rootDir);
        }
    }
}

