/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.testng.AssertJUnit;

public class TestHelper {
    private TestHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyIndex(File rootDir, String indexName, int termsAdded, boolean inverted) throws IOException {
        File indexDir = new File(rootDir, indexName);
        try (FSDirectory directory = FSDirectory.open((File)indexDir);){
            TestHelper.verifyOnDirectory((Directory)directory, termsAdded, inverted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyOnDirectory(Directory directory, int termsAdded, boolean inverted) throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        try {
            for (int i = 0; i <= termsAdded; ++i) {
                TermQuery queryNotToFind;
                TermQuery queryToFind;
                String term = String.valueOf(i);
                if (i % 2 == 0 ^ inverted) {
                    queryToFind = new TermQuery(new Term("main", term));
                    queryNotToFind = new TermQuery(new Term("secondaryField", term));
                } else {
                    queryToFind = new TermQuery(new Term("secondaryField", term));
                    queryNotToFind = new TermQuery(new Term("main", term));
                }
                TopDocs docs = searcher.search((Query)queryToFind, null, 2);
                AssertJUnit.assertEquals((String)("String '" + term + "' should exist but was not found in index"), (int)1, (int)docs.totalHits);
                docs = searcher.search((Query)queryNotToFind, null, 1);
                AssertJUnit.assertEquals((String)("String '" + term + "' should NOT exist but was found in index"), (int)0, (int)docs.totalHits);
            }
        }
        finally {
            indexReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndex(File rootDir, String indexName, int termsToAdd, boolean invert) throws IOException {
        File indexDir = new File(rootDir, indexName);
        try (FSDirectory directory = FSDirectory.open((File)indexDir);){
            CacheTestSupport.initializeDirectory((Directory)directory);
            try (IndexWriter iwriter = LuceneSettings.openWriter((Directory)directory, 100000);){
                for (int i = 0; i <= termsToAdd; ++i) {
                    Document doc = new Document();
                    String term = String.valueOf(i);
                    if (i % 2 == 0 ^ invert) {
                        doc.add((IndexableField)new StringField("main", term, Field.Store.NO));
                    } else {
                        doc.add((IndexableField)new StringField("secondaryField", term, Field.Store.YES));
                    }
                    iwriter.addDocument((Iterable)doc);
                }
                iwriter.commit();
            }
        }
    }

    public static File createRootDir(String parentDir, String rootDirectoryName) {
        File rootDir = new File(new File(parentDir).getAbsoluteFile(), rootDirectoryName);
        boolean directoriesCreated = rootDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for test";
        rootDir.deleteOnExit();
        return rootDir;
    }

    public static String[] getFileNamesFromDir(File rootDir, String indexName) {
        File indexDir = new File(rootDir.getAbsoluteFile(), indexName);
        assert (indexDir.exists());
        String[] fileNames = indexDir.list();
        assert (fileNames.length > 0);
        return fileNames;
    }
}

