/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class LuceneUtils {
    private LuceneUtils() {
    }

    public static Set<String> readTerms(String field, Directory directory) throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            TreeSet<String> termStrings = new TreeSet<String>();
            for (AtomicReaderContext atomicReaderContext : reader.leaves()) {
                AtomicReader atomicReader = atomicReaderContext.reader();
                TermsEnum iterator = atomicReader.terms(field).iterator(null);
                BytesRef next = iterator.next();
                while (next != null) {
                    termStrings.add(iterator.term().utf8ToString());
                    next = iterator.next();
                }
            }
            TreeSet<String> treeSet = termStrings;
            return treeSet;
        }
    }

    public static int numDocs(Directory directory) throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            int n = reader.numDocs();
            return n;
        }
    }

    public static List<Document> collect(Directory directory, int limit) throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            MatchAllDocsQuery allDocsQuery = new MatchAllDocsQuery();
            ArrayList<Document> docs = new ArrayList<Document>(limit);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)reader);
            TopDocs topDocs = indexSearcher.search((Query)allDocsQuery, limit);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                docs.add(indexSearcher.doc(scoreDoc.doc));
            }
            ArrayList<Document> arrayList = docs;
            return arrayList;
        }
    }
}

