/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.cacheloader.DirectoryLoaderAdaptor;
import org.infinispan.lucene.cacheloader.TestHelper;
import org.infinispan.lucene.cacheloader.configuration.LuceneLoaderConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cachestore.IndexCacheLoaderTest")
public class IndexCacheLoaderTest {
    private static final int SCALE = 600;
    protected final String parentDir = TestingUtil.tmpDirectory(this.getClass());
    protected File rootDir = null;

    @BeforeMethod
    public void setUp() {
        this.rootDir = TestHelper.createRootDir(this.parentDir, this.getIndexPathName());
    }

    protected String getIndexPathName() {
        return this.getClass().getSimpleName();
    }

    @AfterMethod
    public void tearDown() {
        if (this.rootDir != null) {
            TestingUtil.recursiveFileRemove((File)this.rootDir);
        }
    }

    @Test
    public void testRescalingMath() {
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)0L, (int)1), (int)0);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)1L, (int)1), (int)1);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)2L, (int)1), (int)2);
        int MB = 0x100000;
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)0L, (int)MB), (int)0);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)1L, (int)MB), (int)1);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)2L, (int)MB), (int)1);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)MB, (int)MB), (int)1);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)(MB + 1), (int)MB), (int)2);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)(MB + MB), (int)MB), (int)2);
        Assert.assertEquals((int)DirectoryLoaderAdaptor.figureChunksNumber((String)"", (long)(MB + MB + 1), (int)MB), (int)3);
    }

    @Test
    public void testReadExistingIndex() throws IOException {
        TestHelper.createIndex(this.rootDir, "index-A", 6000, true);
        TestHelper.createIndex(this.rootDir, "index-B", 12000, false);
        TestHelper.verifyIndex(this.rootDir, "index-A", 6000, true);
        this.verifyDirectory(this.rootDir, "index-A", 6000, true);
        TestHelper.verifyIndex(this.rootDir, "index-B", 12000, false);
        this.verifyDirectory(this.rootDir, "index-B", 12000, false);
    }

    private void verifyDirectory(File rootDir, final String indexName, final int termsAdded, final boolean inverted) {
        final EmbeddedCacheManager cacheManager = this.initializeInfinispan(rootDir);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

            public void call() throws IOException {
                Cache cache = cacheManager.getCache();
                Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)indexName).create();
                TestHelper.verifyOnDirectory(directory, termsAdded, inverted);
            }
        });
    }

    protected EmbeddedCacheManager initializeInfinispan(File rootDir) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((LuceneLoaderConfigurationBuilder)((LuceneLoaderConfigurationBuilder)builder.persistence().addStore(LuceneLoaderConfigurationBuilder.class)).autoChunkSize(1024).preload(true)).location(rootDir.getAbsolutePath());
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }
}

